package com.thebeastshop.mbgw.sdk.request;


import com.alibaba.fastjson.annotation.JSONField;

/**
 * 马帮订单发货请求（仅platformOrderId必填，其他参数可选）
 * 对应接口：order-do-deliver-order（需与官方文档一致）
 */
public class DeliverOrderRequest extends MbGwRequest {

    private static final String API_METHOD = "order-do-deliver-order"; // 接口名，以官方为准

    // 平台订单编号（唯一必填参数）
    @JSONField(name = "platformOrderId")
    private String platformOrderId;

    // 订单重量（可选，单位kg，如"1.2"）
    @JSONField(name = "orderWeight")
    private String orderWeight;

    // ERP物流渠道编号（可选，未传则使用订单默认渠道）
    @JSONField(name = "myLogisticsChannelId")
    private String myLogisticsChannelId;

    // 货运单号（可选，未传则由物流渠道自动生成）
    @JSONField(name = "trackNumber")
    private String trackNumber;

    // 内部单号（可选）
    @JSONField(name = "trackNumber1")
    private String trackNumber1;

    // 虚拟单号（可选）
    @JSONField(name = "trackNumber2")
    private String trackNumber2;

    // 是否强制发货（可选，1-强制，2-非强制，默认2）
    @JSONField(name = "isForce")
    private Integer isForce = 2;

    // 构造器（仅强制传入必填参数platformOrderId）
    public DeliverOrderRequest(String platformOrderId) {
        super(API_METHOD);
        this.platformOrderId = platformOrderId;
        validateRequired(); // 仅校验必填项
    }

    // 校验：仅确保platformOrderId非空
    private void validateRequired() {
        if (platformOrderId == null || platformOrderId.trim().isEmpty()) {
            throw new IllegalArgumentException("平台订单编号（platformOrderId）不能为空");
        }
        // 非必填参数宽松校验：isForce仅允许1或2（默认2）
        if (isForce != null && (isForce != 1 && isForce != 2)) {
            throw new IllegalArgumentException("是否强制发货（isForce）仅支持1（强制）或2（非强制）");
        }
    }

    // 链式Setter（所有非必填参数，支持按需设置）
    public DeliverOrderRequest setOrderWeight(String orderWeight) {
        this.orderWeight = orderWeight;
        return this;
    }

    public DeliverOrderRequest setMyLogisticsChannelId(String myLogisticsChannelId) {
        this.myLogisticsChannelId = myLogisticsChannelId;
        return this;
    }

    public DeliverOrderRequest setTrackNumber(String trackNumber) {
        this.trackNumber = trackNumber;
        return this;
    }

    public DeliverOrderRequest setTrackNumber1(String trackNumber1) {
        this.trackNumber1 = trackNumber1;
        return this;
    }

    public DeliverOrderRequest setTrackNumber2(String trackNumber2) {
        this.trackNumber2 = trackNumber2;
        return this;
    }

    public DeliverOrderRequest setIsForce(Integer isForce) {
        this.isForce = isForce;
        validateRequired(); // 重新校验isForce合法性
        return this;
    }

    // Getter（供JSON序列化）
    public String getPlatformOrderId() { return platformOrderId; }
    public String getOrderWeight() { return orderWeight; }
    public String getMyLogisticsChannelId() { return myLogisticsChannelId; }
    public String getTrackNumber() { return trackNumber; }
    public String getTrackNumber1() { return trackNumber1; }
    public String getTrackNumber2() { return trackNumber2; }
    public Integer getIsForce() { return isForce; }
}
