package com.thebeastshop.mbgw.sdk.model.order;


import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单商品明细子模型
 */
public class OrderItem implements Serializable {
    private static final long serialVersionUID = 5382009190545116726L;
    @JSONField(name = "salesRecordNumber")
    private String salesRecordNumber; // 商品行号（用于拆单接口）

    @JSONField(name = "costPrice")
    private BigDecimal costPrice; // 商品成本价

    @JSONField(name = "deliverOperId")
    private String deliverOperId; // 配货员

    @JSONField(name = "fbaHpreeIds")
    private Integer fbaHpreeIds; // 转fba.msku数量

    @JSONField(name = "hasGoods")
    private Integer hasGoods; // 缺货订单（0计算中，1有货，2缺货，3已补货）

    @JSONField(name = "orderItemId")
    private String orderItemId; // 订单平台商品编号

    @JSONField(name = "comboSkuId")
    private String comboSkuId; // 组合SKUid

    @JSONField(name = "comboSerialNo")
    private String comboSerialNo; // 组合SKU唯一行号

    @JSONField(name = "isCombo")
    private Integer isCombo; // 是否组合商品（1是，2否）

    @JSONField(name = "isGift")
    private Integer isGift; // 是否赠品（1是，2否）

    @JSONField(name = "isRepeatItem")
    private Integer isRepeatItem; // 预留字段（0）

    @JSONField(name = "ASIN")
    private String ASIN; // ASIN

    @JSONField(name = "ispaste")
    private Integer ispaste; // 是否膏体（1是，2否）

    @JSONField(name = "itemId")
    private String itemId; // 平台itemId

    @JSONField(name = "itemRemark")
    private String itemRemark; // 订单商品备注

    @JSONField(name = "noLiquidCosmetic")
    private Integer noLiquidCosmetic; // 液体类型（0非液体，1非液体化妆品，2液体化妆品，3液体非化妆品）

    @JSONField(name = "originOrderId")
    private String originOrderId; // ERP系统关联订单编号

    @JSONField(name = "originalPictureUrl")
    private String originalPictureUrl; // 电商平台商品图片

    @JSONField(name = "pictureUrl")
    private String pictureUrl; // 商品图片

    @JSONField(name = "platformFee")
    private BigDecimal platformFee; // 平台费

    @JSONField(name = "platform_item_warehouse_name")
    private String platformItemWarehouseName; // 商品平台发货仓库

    @JSONField(name = "platformFeeOrigin")
    private BigDecimal platformFeeOrigin; // 原始平台费

    @JSONField(name = "platformQuantity")
    private Integer platformQuantity; // 平台原始sku数量

    @JSONField(name = "platformSku")
    private String platformSku; // 平台sku

    @JSONField(name = "productUnit")
    private String productUnit; // 商品单位

    @JSONField(name = "quantity")
    private Integer quantity; // 商品数量

    @JSONField(name = "salesOperId")
    private String salesOperId; // 销售员账号

    @JSONField(name = "sellPrice")
    private BigDecimal sellPrice; // 商品售价

    @JSONField(name = "sellPriceOrigin")
    private BigDecimal sellPriceOrigin; // 商品原始售价

    @JSONField(name = "specifics")
    private String specifics; // 商品多属性

    @JSONField(name = "status")
    private Integer status; // 商品状态（1未付款，2未发货，3已发货，4已作废）

    @JSONField(name = "stockGrid")
    private String stockGrid; // 商品仓位

    @JSONField(name = "stockId")
    private String stockId; // 库存ID

    @JSONField(name = "stockSku")
    private String stockSku; // 库存sku

    @JSONField(name = "stockStatus")
    private Integer stockStatus; // 库存状态（1自动创建，2待开发，3正常，4清仓，5停止销售）

    @JSONField(name = "stockWarehouseId")
    private String stockWarehouseId; // 商品仓库编号

    @JSONField(name = "storageSku")
    private String storageSku; // 原厂SKU

    @JSONField(name = "platformProductId")
    private String platformProductId; // 主商品ID

    @JSONField(name = "title")
    private String title; // 商品标题（最大1000字符）

    @JSONField(name = "transactionId")
    private String transactionId; // 平台transactionId

    @JSONField(name = "unitWeight")
    private BigDecimal unitWeight; // 商品单品重量

    @JSONField(name = "stockWarehouseName")
    private String stockWarehouseName; // 商品仓库名称

    @JSONField(name = "erpOrderItemId")
    private String erpOrderItemId; // 马帮订单商品明细ID

    @JSONField(name = "realpay_product_amount")
    private BigDecimal realpayProductAmount; // 单商品实付金额（仅Lazada平台）

    // Getter/Setter（全部字段）
    public String getSalesRecordNumber() { return salesRecordNumber; }
    public void setSalesRecordNumber(String salesRecordNumber) { this.salesRecordNumber = salesRecordNumber; }
    public BigDecimal getCostPrice() { return costPrice; }
    public void setCostPrice(BigDecimal costPrice) { this.costPrice = costPrice; }
    public String getDeliverOperId() { return deliverOperId; }
    public void setDeliverOperId(String deliverOperId) { this.deliverOperId = deliverOperId; }
    public Integer getFbaHpreeIds() { return fbaHpreeIds; }
    public void setFbaHpreeIds(Integer fbaHpreeIds) { this.fbaHpreeIds = fbaHpreeIds; }
    public Integer getHasGoods() { return hasGoods; }
    public void setHasGoods(Integer hasGoods) { this.hasGoods = hasGoods; }
    public String getOrderItemId() { return orderItemId; }
    public void setOrderItemId(String orderItemId) { this.orderItemId = orderItemId; }
    public String getComboSkuId() { return comboSkuId; }
    public void setComboSkuId(String comboSkuId) { this.comboSkuId = comboSkuId; }
    public String getComboSerialNo() { return comboSerialNo; }
    public void setComboSerialNo(String comboSerialNo) { this.comboSerialNo = comboSerialNo; }
    public Integer getIsCombo() { return isCombo; }
    public void setIsCombo(Integer isCombo) { this.isCombo = isCombo; }
    public Integer getIsGift() { return isGift; }
    public void setIsGift(Integer isGift) { this.isGift = isGift; }
    public Integer getIsRepeatItem() { return isRepeatItem; }
    public void setIsRepeatItem(Integer isRepeatItem) { this.isRepeatItem = isRepeatItem; }
    public String getASIN() { return ASIN; }
    public void setASIN(String ASIN) { this.ASIN = ASIN; }
    public Integer getIspaste() { return ispaste; }
    public void setIspaste(Integer ispaste) { this.ispaste = ispaste; }
    public String getItemId() { return itemId; }
    public void setItemId(String itemId) { this.itemId = itemId; }
    public String getItemRemark() { return itemRemark; }
    public void setItemRemark(String itemRemark) { this.itemRemark = itemRemark; }
    public Integer getNoLiquidCosmetic() { return noLiquidCosmetic; }
    public void setNoLiquidCosmetic(Integer noLiquidCosmetic) { this.noLiquidCosmetic = noLiquidCosmetic; }
    public String getOriginOrderId() { return originOrderId; }
    public void setOriginOrderId(String originOrderId) { this.originOrderId = originOrderId; }
    public String getOriginalPictureUrl() { return originalPictureUrl; }
    public void setOriginalPictureUrl(String originalPictureUrl) { this.originalPictureUrl = originalPictureUrl; }
    public String getPictureUrl() { return pictureUrl; }
    public void setPictureUrl(String pictureUrl) { this.pictureUrl = pictureUrl; }
    public BigDecimal getPlatformFee() { return platformFee; }
    public void setPlatformFee(BigDecimal platformFee) { this.platformFee = platformFee; }
    public String getPlatformItemWarehouseName() { return platformItemWarehouseName; }
    public void setPlatformItemWarehouseName(String platformItemWarehouseName) { this.platformItemWarehouseName = platformItemWarehouseName; }
    public BigDecimal getPlatformFeeOrigin() { return platformFeeOrigin; }
    public void setPlatformFeeOrigin(BigDecimal platformFeeOrigin) { this.platformFeeOrigin = platformFeeOrigin; }
    public Integer getPlatformQuantity() { return platformQuantity; }
    public void setPlatformQuantity(Integer platformQuantity) { this.platformQuantity = platformQuantity; }
    public String getPlatformSku() { return platformSku; }
    public void setPlatformSku(String platformSku) { this.platformSku = platformSku; }
    public String getProductUnit() { return productUnit; }
    public void setProductUnit(String productUnit) { this.productUnit = productUnit; }
    public Integer getQuantity() { return quantity; }
    public void setQuantity(Integer quantity) { this.quantity = quantity; }
    public String getSalesOperId() { return salesOperId; }
    public void setSalesOperId(String salesOperId) { this.salesOperId = salesOperId; }
    public BigDecimal getSellPrice() { return sellPrice; }
    public void setSellPrice(BigDecimal sellPrice) { this.sellPrice = sellPrice; }
    public BigDecimal getSellPriceOrigin() { return sellPriceOrigin; }
    public void setSellPriceOrigin(BigDecimal sellPriceOrigin) { this.sellPriceOrigin = sellPriceOrigin; }
    public String getSpecifics() { return specifics; }
    public void setSpecifics(String specifics) { this.specifics = specifics; }
    public Integer getStatus() { return status; }
    public void setStatus(Integer status) { this.status = status; }
    public String getStockGrid() { return stockGrid; }
    public void setStockGrid(String stockGrid) { this.stockGrid = stockGrid; }
    public String getStockId() { return stockId; }
    public void setStockId(String stockId) { this.stockId = stockId; }
    public String getStockSku() { return stockSku; }
    public void setStockSku(String stockSku) { this.stockSku = stockSku; }
    public Integer getStockStatus() { return stockStatus; }
    public void setStockStatus(Integer stockStatus) { this.stockStatus = stockStatus; }
    public String getStockWarehouseId() { return stockWarehouseId; }
    public void setStockWarehouseId(String stockWarehouseId) { this.stockWarehouseId = stockWarehouseId; }
    public String getStorageSku() { return storageSku; }
    public void setStorageSku(String storageSku) { this.storageSku = storageSku; }
    public String getPlatformProductId() { return platformProductId; }
    public void setPlatformProductId(String platformProductId) { this.platformProductId = platformProductId; }
    public String getTitle() { return title; }
    public void setTitle(String title) { this.title = title; }
    public String getTransactionId() { return transactionId; }
    public void setTransactionId(String transactionId) { this.transactionId = transactionId; }
    public BigDecimal getUnitWeight() { return unitWeight; }
    public void setUnitWeight(BigDecimal unitWeight) { this.unitWeight = unitWeight; }
    public String getStockWarehouseName() { return stockWarehouseName; }
    public void setStockWarehouseName(String stockWarehouseName) { this.stockWarehouseName = stockWarehouseName; }
    public String getErpOrderItemId() { return erpOrderItemId; }
    public void setErpOrderItemId(String erpOrderItemId) { this.erpOrderItemId = erpOrderItemId; }
    public BigDecimal getRealpayProductAmount() { return realpayProductAmount; }
    public void setRealpayProductAmount(BigDecimal realpayProductAmount) { this.realpayProductAmount = realpayProductAmount; }
}
