package com.thebeastshop.mbgw.sdk.model.order;


import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 订单详情子模型（与接口返回字段完全对齐）
 */
public class OrderDetail implements Serializable {
    private static final long serialVersionUID = -779808125099896806L;
    // 基础信息
    @JSONField(name = "expressOperId")
    private String expressOperId; // 发货人

    @JSONField(name = "platformOrderId")
    private String platformOrderId; // 订单编号

    @JSONField(name = "orderStatus")
    private Integer orderStatus; // 订单状态（2配货中/待处理，3已发货，4已完成，5已作废）

    @JSONField(name = "myLogisticsId")
    private String myLogisticsId; // 物流公司编号

    @JSONField(name = "myLogisticsChannelId")
    private Integer myLogisticsChannelId; // 物流渠道编号

    @JSONField(name = "trackNumber")
    private String trackNumber; // 物流单号

    @JSONField(name = "trackNumber1")
    private String trackNumber1; // 内部单号

    @JSONField(name = "trackNumber2")
    private String trackNumber2; // 虚拟单号

    @JSONField(name = "orderWeight")
    private BigDecimal orderWeight; // 订单重量

    @JSONField(name = "is_settlement")
    private Integer isSettlement; // 结算状态（1已结算，2未结算）

    @JSONField(name = "settlement")
    private Settlement settlement; // 结算信息

    @JSONField(name = "buyerUserId")
    private String buyerUserId; // 买家账号

    @JSONField(name = "send_again_order")
    private String sendAgainOrder; // 转寄订单号

    @JSONField(name = "buyerName")
    private String buyerName; // 买家姓名

    @JSONField(name = "source")
    private Integer source; // 订单来源（1手动，2上传，3接口）

    @JSONField(name = "shopId")
    private Integer shopId; // 店铺编号

    @JSONField(name = "companyId")
    private String companyId; // 企业编号

    @JSONField(name = "sellerName")
    private String sellerName; // 业务员

    @JSONField(name = "countryCode")
    private String countryCode; // 国家二字码

    @JSONField(name = "orderCost")
    private BigDecimal orderCost; // 订单成本价

    @JSONField(name = "codFlag")
    private Integer codFlag; // 订单标识（1默认，10COD订单，11WE标识，12COD+WE）

    @JSONField(name = "printCount")
    private Integer printCount; // 打印次数

    @JSONField(name = "printTime", format = "yyyy-MM-dd HH:mm:ss")
    private Date printTime; // 打印时间

    @JSONField(name = "printPreviewCount")
    private Integer printPreviewCount; // 预览打印次数

    @JSONField(name = "choice_flag")
    private Integer choiceFlag; // 订单业务模式（1POP，2半托管，3全托管）

    @JSONField(name = "transportTime", format = "yyyy-MM-dd HH:mm:ss")
    private Date transportTime; // 交运时间

    @JSONField(name = "platform_buffer_date", format = "yyyy-MM-dd HH:mm:ss")
    private Date platformBufferDate; // 平台指定交运时间（仅部分平台）

    @JSONField(name = "order_peihuo_time", format = "yyyy-MM-dd HH:mm:ss")
    private Date orderPeihuoTime; // 转入配货中时间

    @JSONField(name = "is_sample_order")
    private Integer isSampleOrder; // 样品订单（1是，2否）

    @JSONField(name = "is_preorder")
    private Integer isPreorder; // 预售订单（1是，2否）

    @JSONField(name = "quickPickTime", format = "yyyy-MM-dd HH:mm:ss")
    private Date quickPickTime; // 转wms发货时间

    @JSONField(name = "canSend")
    private Integer canSend; // 待审核订单（1否，2是）

    @JSONField(name = "createDate", format = "yyyy-MM-dd HH:mm:ss")
    private Date createDate; // 订单同步ERP时间

    @JSONField(name = "isReturned")
    private Integer isReturned; // 退货标识（1退货，2非退货）

    @JSONField(name = "isRefund")
    private Integer isRefund; // 退款标识（1退款，2非退款）

    @JSONField(name = "riskType")
    private String riskType; // 风险订单等级（high/low/middle）

    @JSONField(name = "reissue_origin_code")
    private String reissueOriginCode; // 重发来源订单编号

    @JSONField(name = "headShipping")
    private BigDecimal headShipping; // 头程运费

    @JSONField(name = "isImmediately")
    private Integer isImmediately; // 发货扣库存（1扣，2不扣）

    @JSONField(name = "paidTime", format = "yyyy-MM-dd HH:mm:ss")
    private Date paidTime; // 订单付款时间

    @JSONField(name = "salesRecordNumber")
    private String salesRecordNumber; // 平台交易号

    @JSONField(name = "orderFee")
    private BigDecimal orderFee; // 订单金额

    @JSONField(name = "platformId")
    private String platformId; // 来源平台

    @JSONField(name = "expressTime", format = "yyyy-MM-dd HH:mm:ss")
    private Date expressTime; // 发货时间

    @JSONField(name = "abnormalType")
    private Integer abnormalType; // 已发货异常分类（4退款，5买家取消等）

    @JSONField(name = "isUnion")
    private Integer isUnion; // 合并订单（1是，2否）

    @JSONField(name = "isSplit")
    private Integer isSplit; // 拆分订单（1是，2否）

    @JSONField(name = "isResend")
    private Integer isResend; // 重发订单（1是，2否）

    @JSONField(name = "exceptionReasonId")
    private String exceptionReasonId; // 重发原因id

    @JSONField(name = "isTuotou")
    private Integer isTuotou; // 妥投标识（1平台妥投，11人工妥投，2非妥投）

    @JSONField(name = "hasGoods")
    private Integer hasGoods; // 缺货订单（0计算中，1有货，2缺货，3已补货）

    @JSONField(name = "hasBattery")
    private Integer hasBattery; // 含电池（1是，2否）

    @JSONField(name = "isSyncLogisticsDescr")
    private String isSyncLogisticsDescr; // 交运结果描述

    @JSONField(name = "otto_refund_order_number")
    private String ottoRefundOrderNumber; // OTTO退货单号

    @JSONField(name = "paypalId")
    private String paypalId; // paypalId

    @JSONField(name = "platformArrivalTime", format = "yyyy-MM-dd HH:mm:ss")
    private Date platformArrivalTime; // 平台送达时间（仅亚马逊）

    @JSONField(name = "isSyncLogistics")
    private Integer isSyncLogistics; // 交运状态（0未调用，1开始调用等）

    @JSONField(name = "isSyncPlatform")
    private Integer isSyncPlatform; // 同步平台状态（1未同步，2等待交运等）

    @JSONField(name = "isSyncPlatformDescr")
    private String isSyncPlatformDescr; // 同步结果说明

    @JSONField(name = "town")
    private String town; // 所属镇

    @JSONField(name = "update_time", format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime; // 最后更新时间

    @JSONField(name = "district")
    private String district; // 所属区域

    @JSONField(name = "paypalEmail")
    private String paypalEmail; // 收款账号

    @JSONField(name = "closeDate", format = "yyyy-MM-dd HH:mm:ss")
    private Date closeDate; // 交易关闭时间

    @JSONField(name = "customerAbnnumber")
    private String customerAbnnumber; // 订单Abnnumber

    @JSONField(name = "is_lottery_order")
    private Integer isLotteryOrder; // tiktok直播礼赠订单（1是，2否）

    @JSONField(name = "street1")
    private String street1; // 买家地址1

    @JSONField(name = "street2")
    private String street2; // 买家地址2

    @JSONField(name = "billing_address")
    private String billingAddress; // 账单地址

    @JSONField(name = "isVirtual")
    private Integer isVirtual; // 虚假发货订单（1是，2否）

    @JSONField(name = "isForecast")
    private Integer isForecast; // 预报标识（1成功，2失败）

    @JSONField(name = "city")
    private String city; // 买家城市

    @JSONField(name = "province")
    private String province; // 买家省份

    @JSONField(name = "postCode")
    private String postCode; // 买家邮编

    @JSONField(name = "phone1")
    private String phone1; // 买家电话1

    @JSONField(name = "phone2")
    private String phone2; // 买家电话2

    @JSONField(name = "email")
    private String email; // email

    @JSONField(name = "isNewOrder")
    private Integer isNewOrder; // 1待处理订单，2配货中订单

    @JSONField(name = "doorcode")
    private String doorcode; // 买家门牌号

    @JSONField(name = "fbaFlag")
    private Integer fbaFlag; // 平台发货订单（1否，2是）


        // 基础信息（已补全剩余字段）
        @JSONField(name = "fbaStartDateTime", format = "yyyy-MM-dd HH:mm:ss")
        private Date fbaStartDateTime; // Fba开始配送时间

        @JSONField(name = "fbaEndDateTime", format = "yyyy-MM-dd HH:mm:ss")
        private Date fbaEndDateTime; // Fba配送结束时间

        @JSONField(name = "customizedURL")
        private String customizedURL; // 亚马逊买家定制信息

        @JSONField(name = "CarrierCode")
        private String carrierCode; // Fba承运人

        @JSONField(name = "push_fba_number")
        private String pushFbaNumber; // FBA卖家单据编号

        @JSONField(name = "fba_outbound_number")
        private String fbaOutboundNumber; // FBA亚马逊单据编号

        @JSONField(name = "push_fba_shopname")
        private String pushFbaShopname; // FBA发货店铺名称

        @JSONField(name = "source_document_number")
        private String sourceDocumentNumber; // 多渠道订单来源订单编号

        @JSONField(name = "source_shop_name")
        private String sourceShopName; // 多渠道订单来源店铺

        @JSONField(name = "operId")
        private String operId; // 操作员

        @JSONField(name = "operTime", format = "yyyy-MM-dd HH:mm:ss")
        private Date operTime; // 操作时间

        @JSONField(name = "shippingService")
        private String shippingService; // 买家自选物流

        @JSONField(name = "packageWeight")
        private BigDecimal packageWeight; // 包材重量

        @JSONField(name = "platformOrderStatus")
        private String platformOrderStatus; // 平台的订单状态（无固定枚举）

        @JSONField(name = "isUrgent")
        private Integer isUrgent; // 加急标识（1加急，2不加急）

        @JSONField(name = "isEvaluation")
        private Integer isEvaluation; // 测评订单（1是，2否）

        @JSONField(name = "tankno")
        private String tankno; // 网点编码

        @JSONField(name = "companyStreet")
        private String companyStreet; // 名称

        @JSONField(name = "hasMagnetic")
        private Integer hasMagnetic; // 含磁（1含，2不含）

        @JSONField(name = "hasPowder")
        private Integer hasPowder; // 含粉末（1含，2不含）

        @JSONField(name = "hasTort")
        private Integer hasTort; // 侵权（1含，2不含）

        @JSONField(name = "remark")
        private String remark; // 订单备注

        @JSONField(name = "sellerMessage")
        private String sellerMessage; // 平台备注

        @JSONField(name = "buyerMessage")
        private String buyerMessage; // 平台留言

        @JSONField(name = "currencyId")
        private String currencyId; // 币种

        @JSONField(name = "currencyRate")
        private BigDecimal currencyRate; // 汇率

        @JSONField(name = "itemTotal")
        private BigDecimal itemTotal; // 商品总售价

        @JSONField(name = "shippingFee")
        private BigDecimal shippingFee; // 运费收入

        @JSONField(name = "platformFee")
        private BigDecimal platformFee; // 平台费

        @JSONField(name = "other_expend_origin")
        private BigDecimal otherExpendOrigin; // 其他支出（原始）

        @JSONField(name = "other_income_origin")
        private BigDecimal otherIncomeOrigin; // 其他收入（原始）

        @JSONField(name = "shippingTotalOrigin")
        private BigDecimal shippingTotalOrigin; // 原始运费收入

        @JSONField(name = "itemTotalOrigin")
        private BigDecimal itemTotalOrigin; // 商品原始总售价

        @JSONField(name = "refundFeeOrigin")
        private BigDecimal refundFeeOrigin; // 退款金额（原始）

        @JSONField(name = "platformTotalPrice")
        private BigDecimal platformTotalPrice; // 合计金额（乐天未抵扣积分）

        @JSONField(name = "refundFeeCurrencyId")
        private String refundFeeCurrencyId; // 退款金额币种

        @JSONField(name = "originFax")
        private BigDecimal originFax; // 原始税费

        @JSONField(name = "beforeStatus")
        private String beforeStatus; // 作废前订单状态（待审核/待处理/配货中：2；已发货：3等）

        @JSONField(name = "before_cansend")
        private Integer beforeCansend; // 作废前异常状态（1正常，2异常）

        @JSONField(name = "otherExpend")
        private BigDecimal otherExpend; // 其他支出

        @JSONField(name = "otherIncome")
        private BigDecimal otherIncome; // 其他收入

        @JSONField(name = "ShippingChargeback")
        private BigDecimal shippingChargeback; // 配送信用卡拒付

        @JSONField(name = "VariableClosingFee")
        private BigDecimal variableClosingFee; // 非固定交易手续费

        @JSONField(name = "vatFee")
        private BigDecimal vatFee; // VAT税费

        @JSONField(name = "vatFeeOrigin")
        private BigDecimal vatFeeOrigin; // VAT原始税费

        @JSONField(name = "evaluationFee")
        private BigDecimal evaluationFee; // 测评费

        @JSONField(name = "insuranceFee")
        private BigDecimal insuranceFee; // 保险费

        @JSONField(name = "insuranceFeeOrigin")
        private BigDecimal insuranceFeeOrigin; // 原始保险费

        @JSONField(name = "paypalFee")
        private BigDecimal paypalFee; // Paypal转账费

        @JSONField(name = "paypalFeeOrigin")
        private BigDecimal paypalFeeOrigin; // 原始Paypal转账费

        @JSONField(name = "itemTotalCost")
        private BigDecimal itemTotalCost; // 商品总成本

        @JSONField(name = "shippingCost")
        private BigDecimal shippingCost; // 真实运费

        @JSONField(name = "shippingPreCost")
        private BigDecimal shippingPreCost; // 预估运费

        @JSONField(name = "packageFee")
        private BigDecimal packageFee; // 包材费

        @JSONField(name = "fbaPerOrderFulfillmentFee")
        private BigDecimal fbaPerOrderFulfillmentFee; // FBA每笔订单配送服务费

        @JSONField(name = "fbaCommission")
        private BigDecimal fbaCommission; // 亚马逊平台佣金

        @JSONField(name = "promotionAmount")
        private BigDecimal promotionAmount; // 折扣RMB金额

        @JSONField(name = "promotionAmountOrigin")
        private BigDecimal promotionAmountOrigin; // 折扣原始金额

        @JSONField(name = "allianceFeeOrigin")
        private BigDecimal allianceFeeOrigin; // 原始联盟佣金

        @JSONField(name = "voucherPriceOrigin")
        private BigDecimal voucherPriceOrigin; // 原始优惠券

        @JSONField(name = "subsidyAmountOrigin")
        private BigDecimal subsidyAmountOrigin; // 原始补贴金额

        @JSONField(name = "CODCharge")
        private BigDecimal codCharge; // fba货到付款金额

        @JSONField(name = "allianceFee")
        private BigDecimal allianceFee; // 联盟佣金

        @JSONField(name = "fbaPerUnitFulfillmentFee")
        private BigDecimal fbaPerUnitFulfillmentFee; // 亚马逊物流基础服务费

        @JSONField(name = "fbaWeightBasedFee")
        private BigDecimal fbaWeightBasedFee; // fba亚马逊物流配送费

        @JSONField(name = "platformFeeOrigin")
        private BigDecimal platformFeeOrigin; // 原始平台费

        @JSONField(name = "voucherPrice")
        private BigDecimal voucherPrice; // 优惠券

        @JSONField(name = "subsidyAmount")
        private BigDecimal subsidyAmount; // 补贴金额

        @JSONField(name = "isWms")
        private Integer isWms; // 1.wms，2.非wms

        @JSONField(name = "payType")
        private String payType; // 付款方式

        @JSONField(name = "VendorID")
        private String vendorID; // VendorID

        @JSONField(name = "abnnumber")
        private String abnnumber; // 税号


        @JSONField(name = "countryNameEN")
        private String countryNameEN; // 国家英文名称

        @JSONField(name = "countryNameCN")
        private String countryNameCN; // 国家中文名称

        @JSONField(name = "shopName")
        private String shopName; // 店铺名称

        @JSONField(name = "myLogisticsChannelName")
        private String myLogisticsChannelName; // 物流渠道名称

        @JSONField(name = "myLogisticsName")
        private String myLogisticsName; // 物流公司名称

        @JSONField(name = "totalOrigin")
        private BigDecimal totalOrigin; // 原始货币总金额

        @JSONField(name = "platformCode")
        private Integer platformCode; // 对应平台的ID

        @JSONField(name = "contributiontype")
        private Integer contributiontype; // 出资类型（1买家出资，2平台出资，默认0）

        @JSONField(name = "orderTypeNew")
        private OrderTypeNew orderTypeNew; // 订单标签分类

        @JSONField(name = "orderType")
        private String orderType; // 订单自动处理匹配分类

        @JSONField(name = "orderItem")
        private List<OrderItem> orderItem; // 商品明细列表

        @JSONField(name = "orderItemDeclareData")
        private List<OrderItemDeclareData> orderItemDeclareData; // 订单申报信息（预留）

        @JSONField(name = "invoiceData")
        private List<InvoiceData> invoiceData; // 发票信息列表

        @JSONField(name = "erpOrderId")
        private String erpOrderId; // ERP系统订单编号

        @JSONField(name = "shippingWeight")
        private BigDecimal shippingWeight; // 物流称重

        @JSONField(name = "extendAttr")
        private List<ExtendAttr> extendAttr; // 扩展属性列表

        @JSONField(name = "codAmount")
        private BigDecimal codAmount; // 买家实付原始金额

        @JSONField(name = "isCod")
        private Integer isCod; // 是否cod订单（1是，0否）

        @JSONField(name = "subsidyAmountAndVoucherPrice")
        private List<SubsidyVoucher> subsidyAmountAndVoucherPrice; // 补贴优惠列表

        @JSONField(name = "receiver_address_info")
        private ReceiverAddressInfo receiverAddressInfo; // 收货地址信息

        // ------------------------------ 所有字段的 Getter/Setter ------------------------------
        // 基础信息 Getter/Setter（含之前未补全的字段）
        public Date getFbaStartDateTime() { return fbaStartDateTime; }
        public void setFbaStartDateTime(Date fbaStartDateTime) { this.fbaStartDateTime = fbaStartDateTime; }
        public Date getFbaEndDateTime() { return fbaEndDateTime; }
        public void setFbaEndDateTime(Date fbaEndDateTime) { this.fbaEndDateTime = fbaEndDateTime; }
        public String getCustomizedURL() { return customizedURL; }
        public void setCustomizedURL(String customizedURL) { this.customizedURL = customizedURL; }
        public String getCarrierCode() { return carrierCode; }
        public void setCarrierCode(String carrierCode) { this.carrierCode = carrierCode; }
        public String getPushFbaNumber() { return pushFbaNumber; }
        public void setPushFbaNumber(String pushFbaNumber) { this.pushFbaNumber = pushFbaNumber; }
        public String getFbaOutboundNumber() { return fbaOutboundNumber; }
        public void setFbaOutboundNumber(String fbaOutboundNumber) { this.fbaOutboundNumber = fbaOutboundNumber; }
        public String getPushFbaShopname() { return pushFbaShopname; }
        public void setPushFbaShopname(String pushFbaShopname) { this.pushFbaShopname = pushFbaShopname; }
        public String getSourceDocumentNumber() { return sourceDocumentNumber; }
        public void setSourceDocumentNumber(String sourceDocumentNumber) { this.sourceDocumentNumber = sourceDocumentNumber; }
        public String getSourceShopName() { return sourceShopName; }
        public void setSourceShopName(String sourceShopName) { this.sourceShopName = sourceShopName; }
        public String getOperId() { return operId; }
        public void setOperId(String operId) { this.operId = operId; }
        public Date getOperTime() { return operTime; }
        public void setOperTime(Date operTime) { this.operTime = operTime; }
        public String getShippingService() { return shippingService; }
        public void setShippingService(String shippingService) { this.shippingService = shippingService; }
        public BigDecimal getPackageWeight() { return packageWeight; }
        public void setPackageWeight(BigDecimal packageWeight) { this.packageWeight = packageWeight; }
        public String getPlatformOrderStatus() { return platformOrderStatus; }
        public void setPlatformOrderStatus(String platformOrderStatus) { this.platformOrderStatus = platformOrderStatus; }
        public Integer getIsUrgent() { return isUrgent; }
        public void setIsUrgent(Integer isUrgent) { this.isUrgent = isUrgent; }
        public Integer getIsEvaluation() { return isEvaluation; }
        public void setIsEvaluation(Integer isEvaluation) { this.isEvaluation = isEvaluation; }
        public String getTankno() { return tankno; }
        public void setTankno(String tankno) { this.tankno = tankno; }
        public String getCompanyStreet() { return companyStreet; }
        public void setCompanyStreet(String companyStreet) { this.companyStreet = companyStreet; }
        public Integer getHasMagnetic() { return hasMagnetic; }
        public void setHasMagnetic(Integer hasMagnetic) { this.hasMagnetic = hasMagnetic; }
        public Integer getHasPowder() { return hasPowder; }
        public void setHasPowder(Integer hasPowder) { this.hasPowder = hasPowder; }
        public Integer getHasTort() { return hasTort; }
        public void setHasTort(Integer hasTort) { this.hasTort = hasTort; }
        public String getRemark() { return remark; }
        public void setRemark(String remark) { this.remark = remark; }
        public String getSellerMessage() { return sellerMessage; }
        public void setSellerMessage(String sellerMessage) { this.sellerMessage = sellerMessage; }
        public String getBuyerMessage() { return buyerMessage; }
        public void setBuyerMessage(String buyerMessage) { this.buyerMessage = buyerMessage; }
        public String getCurrencyId() { return currencyId; }
        public void setCurrencyId(String currencyId) { this.currencyId = currencyId; }
        public BigDecimal getCurrencyRate() { return currencyRate; }
        public void setCurrencyRate(BigDecimal currencyRate) { this.currencyRate = currencyRate; }
        public BigDecimal getItemTotal() { return itemTotal; }
        public void setItemTotal(BigDecimal itemTotal) { this.itemTotal = itemTotal; }
        public BigDecimal getShippingFee() { return shippingFee; }
        public void setShippingFee(BigDecimal shippingFee) { this.shippingFee = shippingFee; }
        public BigDecimal getPlatformFee() { return platformFee; }
        public void setPlatformFee(BigDecimal platformFee) { this.platformFee = platformFee; }
        public BigDecimal getOtherExpendOrigin() { return otherExpendOrigin; }
        public void setOtherExpendOrigin(BigDecimal otherExpendOrigin) { this.otherExpendOrigin = otherExpendOrigin; }
        public BigDecimal getOtherIncomeOrigin() { return otherIncomeOrigin; }
        public void setOtherIncomeOrigin(BigDecimal otherIncomeOrigin) { this.otherIncomeOrigin = otherIncomeOrigin; }
        public BigDecimal getShippingTotalOrigin() { return shippingTotalOrigin; }
        public void setShippingTotalOrigin(BigDecimal shippingTotalOrigin) { this.shippingTotalOrigin = shippingTotalOrigin; }
        public BigDecimal getItemTotalOrigin() { return itemTotalOrigin; }
        public void setItemTotalOrigin(BigDecimal itemTotalOrigin) { this.itemTotalOrigin = itemTotalOrigin; }
        public BigDecimal getRefundFeeOrigin() { return refundFeeOrigin; }
        public void setRefundFeeOrigin(BigDecimal refundFeeOrigin) { this.refundFeeOrigin = refundFeeOrigin; }
        public BigDecimal getPlatformTotalPrice() { return platformTotalPrice; }
        public void setPlatformTotalPrice(BigDecimal platformTotalPrice) { this.platformTotalPrice = platformTotalPrice; }
        public String getRefundFeeCurrencyId() { return refundFeeCurrencyId; }

    public String getExpressOperId() {
        return expressOperId;
    }

    public void setExpressOperId(String expressOperId) {
        this.expressOperId = expressOperId;
    }

    public String getPlatformOrderId() {
        return platformOrderId;
    }

    public void setPlatformOrderId(String platformOrderId) {
        this.platformOrderId = platformOrderId;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getMyLogisticsId() {
        return myLogisticsId;
    }

    public void setMyLogisticsId(String myLogisticsId) {
        this.myLogisticsId = myLogisticsId;
    }

    public Integer getMyLogisticsChannelId() {
        return myLogisticsChannelId;
    }

    public void setMyLogisticsChannelId(Integer myLogisticsChannelId) {
        this.myLogisticsChannelId = myLogisticsChannelId;
    }

    public String getTrackNumber() {
        return trackNumber;
    }

    public void setTrackNumber(String trackNumber) {
        this.trackNumber = trackNumber;
    }

    public String getTrackNumber1() {
        return trackNumber1;
    }

    public void setTrackNumber1(String trackNumber1) {
        this.trackNumber1 = trackNumber1;
    }

    public String getTrackNumber2() {
        return trackNumber2;
    }

    public void setTrackNumber2(String trackNumber2) {
        this.trackNumber2 = trackNumber2;
    }

    public BigDecimal getOrderWeight() {
        return orderWeight;
    }

    public void setOrderWeight(BigDecimal orderWeight) {
        this.orderWeight = orderWeight;
    }

    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

    public Settlement getSettlement() {
        return settlement;
    }

    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    public String getBuyerUserId() {
        return buyerUserId;
    }

    public void setBuyerUserId(String buyerUserId) {
        this.buyerUserId = buyerUserId;
    }

    public String getSendAgainOrder() {
        return sendAgainOrder;
    }

    public void setSendAgainOrder(String sendAgainOrder) {
        this.sendAgainOrder = sendAgainOrder;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public Integer getShopId() {
        return shopId;
    }

    public void setShopId(Integer shopId) {
        this.shopId = shopId;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public BigDecimal getOrderCost() {
        return orderCost;
    }

    public void setOrderCost(BigDecimal orderCost) {
        this.orderCost = orderCost;
    }

    public Integer getCodFlag() {
        return codFlag;
    }

    public void setCodFlag(Integer codFlag) {
        this.codFlag = codFlag;
    }

    public Integer getPrintCount() {
        return printCount;
    }

    public void setPrintCount(Integer printCount) {
        this.printCount = printCount;
    }

    public Date getPrintTime() {
        return printTime;
    }

    public void setPrintTime(Date printTime) {
        this.printTime = printTime;
    }

    public Integer getPrintPreviewCount() {
        return printPreviewCount;
    }

    public void setPrintPreviewCount(Integer printPreviewCount) {
        this.printPreviewCount = printPreviewCount;
    }

    public Integer getChoiceFlag() {
        return choiceFlag;
    }

    public void setChoiceFlag(Integer choiceFlag) {
        this.choiceFlag = choiceFlag;
    }

    public Date getTransportTime() {
        return transportTime;
    }

    public void setTransportTime(Date transportTime) {
        this.transportTime = transportTime;
    }

    public Date getPlatformBufferDate() {
        return platformBufferDate;
    }

    public void setPlatformBufferDate(Date platformBufferDate) {
        this.platformBufferDate = platformBufferDate;
    }

    public Date getOrderPeihuoTime() {
        return orderPeihuoTime;
    }

    public void setOrderPeihuoTime(Date orderPeihuoTime) {
        this.orderPeihuoTime = orderPeihuoTime;
    }

    public Integer getIsSampleOrder() {
        return isSampleOrder;
    }

    public void setIsSampleOrder(Integer isSampleOrder) {
        this.isSampleOrder = isSampleOrder;
    }

    public Integer getIsPreorder() {
        return isPreorder;
    }

    public void setIsPreorder(Integer isPreorder) {
        this.isPreorder = isPreorder;
    }

    public Date getQuickPickTime() {
        return quickPickTime;
    }

    public void setQuickPickTime(Date quickPickTime) {
        this.quickPickTime = quickPickTime;
    }

    public Integer getCanSend() {
        return canSend;
    }

    public void setCanSend(Integer canSend) {
        this.canSend = canSend;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Integer getIsReturned() {
        return isReturned;
    }

    public void setIsReturned(Integer isReturned) {
        this.isReturned = isReturned;
    }

    public Integer getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Integer isRefund) {
        this.isRefund = isRefund;
    }

    public String getRiskType() {
        return riskType;
    }

    public void setRiskType(String riskType) {
        this.riskType = riskType;
    }

    public String getReissueOriginCode() {
        return reissueOriginCode;
    }

    public void setReissueOriginCode(String reissueOriginCode) {
        this.reissueOriginCode = reissueOriginCode;
    }

    public BigDecimal getHeadShipping() {
        return headShipping;
    }

    public void setHeadShipping(BigDecimal headShipping) {
        this.headShipping = headShipping;
    }

    public Integer getIsImmediately() {
        return isImmediately;
    }

    public void setIsImmediately(Integer isImmediately) {
        this.isImmediately = isImmediately;
    }

    public Date getPaidTime() {
        return paidTime;
    }

    public void setPaidTime(Date paidTime) {
        this.paidTime = paidTime;
    }

    public String getSalesRecordNumber() {
        return salesRecordNumber;
    }

    public void setSalesRecordNumber(String salesRecordNumber) {
        this.salesRecordNumber = salesRecordNumber;
    }

    public BigDecimal getOrderFee() {
        return orderFee;
    }

    public void setOrderFee(BigDecimal orderFee) {
        this.orderFee = orderFee;
    }

    public String getPlatformId() {
        return platformId;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public Date getExpressTime() {
        return expressTime;
    }

    public void setExpressTime(Date expressTime) {
        this.expressTime = expressTime;
    }

    public Integer getAbnormalType() {
        return abnormalType;
    }

    public void setAbnormalType(Integer abnormalType) {
        this.abnormalType = abnormalType;
    }

    public Integer getIsUnion() {
        return isUnion;
    }

    public void setIsUnion(Integer isUnion) {
        this.isUnion = isUnion;
    }

    public Integer getIsSplit() {
        return isSplit;
    }

    public void setIsSplit(Integer isSplit) {
        this.isSplit = isSplit;
    }

    public Integer getIsResend() {
        return isResend;
    }

    public void setIsResend(Integer isResend) {
        this.isResend = isResend;
    }

    public String getExceptionReasonId() {
        return exceptionReasonId;
    }

    public void setExceptionReasonId(String exceptionReasonId) {
        this.exceptionReasonId = exceptionReasonId;
    }

    public Integer getIsTuotou() {
        return isTuotou;
    }

    public void setIsTuotou(Integer isTuotou) {
        this.isTuotou = isTuotou;
    }

    public Integer getHasGoods() {
        return hasGoods;
    }

    public void setHasGoods(Integer hasGoods) {
        this.hasGoods = hasGoods;
    }

    public Integer getHasBattery() {
        return hasBattery;
    }

    public void setHasBattery(Integer hasBattery) {
        this.hasBattery = hasBattery;
    }

    public String getIsSyncLogisticsDescr() {
        return isSyncLogisticsDescr;
    }

    public void setIsSyncLogisticsDescr(String isSyncLogisticsDescr) {
        this.isSyncLogisticsDescr = isSyncLogisticsDescr;
    }

    public String getOttoRefundOrderNumber() {
        return ottoRefundOrderNumber;
    }

    public void setOttoRefundOrderNumber(String ottoRefundOrderNumber) {
        this.ottoRefundOrderNumber = ottoRefundOrderNumber;
    }

    public String getPaypalId() {
        return paypalId;
    }

    public void setPaypalId(String paypalId) {
        this.paypalId = paypalId;
    }

    public Date getPlatformArrivalTime() {
        return platformArrivalTime;
    }

    public void setPlatformArrivalTime(Date platformArrivalTime) {
        this.platformArrivalTime = platformArrivalTime;
    }

    public Integer getIsSyncLogistics() {
        return isSyncLogistics;
    }

    public void setIsSyncLogistics(Integer isSyncLogistics) {
        this.isSyncLogistics = isSyncLogistics;
    }

    public Integer getIsSyncPlatform() {
        return isSyncPlatform;
    }

    public void setIsSyncPlatform(Integer isSyncPlatform) {
        this.isSyncPlatform = isSyncPlatform;
    }

    public String getIsSyncPlatformDescr() {
        return isSyncPlatformDescr;
    }

    public void setIsSyncPlatformDescr(String isSyncPlatformDescr) {
        this.isSyncPlatformDescr = isSyncPlatformDescr;
    }

    public String getTown() {
        return town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCountryNameEN() {
        return countryNameEN;
    }

    public void setCountryNameEN(String countryNameEN) {
        this.countryNameEN = countryNameEN;
    }

    public String getCountryNameCN() {
        return countryNameCN;
    }

    public void setCountryNameCN(String countryNameCN) {
        this.countryNameCN = countryNameCN;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getMyLogisticsChannelName() {
        return myLogisticsChannelName;
    }

    public void setMyLogisticsChannelName(String myLogisticsChannelName) {
        this.myLogisticsChannelName = myLogisticsChannelName;
    }

    public String getMyLogisticsName() {
        return myLogisticsName;
    }

    public void setMyLogisticsName(String myLogisticsName) {
        this.myLogisticsName = myLogisticsName;
    }

    public BigDecimal getTotalOrigin() {
        return totalOrigin;
    }

    public void setTotalOrigin(BigDecimal totalOrigin) {
        this.totalOrigin = totalOrigin;
    }

    public Integer getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(Integer platformCode) {
        this.platformCode = platformCode;
    }

    public Integer getContributiontype() {
        return contributiontype;
    }

    public void setContributiontype(Integer contributiontype) {
        this.contributiontype = contributiontype;
    }

    public OrderTypeNew getOrderTypeNew() {
        return orderTypeNew;
    }

    public void setOrderTypeNew(OrderTypeNew orderTypeNew) {
        this.orderTypeNew = orderTypeNew;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public List<OrderItem> getOrderItem() {
        return orderItem;
    }

    public void setOrderItem(List<OrderItem> orderItem) {
        this.orderItem = orderItem;
    }

    public List<OrderItemDeclareData> getOrderItemDeclareData() {
        return orderItemDeclareData;
    }

    public void setOrderItemDeclareData(List<OrderItemDeclareData> orderItemDeclareData) {
        this.orderItemDeclareData = orderItemDeclareData;
    }

    public List<InvoiceData> getInvoiceData() {
        return invoiceData;
    }

    public void setInvoiceData(List<InvoiceData> invoiceData) {
        this.invoiceData = invoiceData;
    }

    public String getErpOrderId() {
        return erpOrderId;
    }

    public void setErpOrderId(String erpOrderId) {
        this.erpOrderId = erpOrderId;
    }

    public BigDecimal getShippingWeight() {
        return shippingWeight;
    }

    public void setShippingWeight(BigDecimal shippingWeight) {
        this.shippingWeight = shippingWeight;
    }

    public List<ExtendAttr> getExtendAttr() {
        return extendAttr;
    }

    public void setExtendAttr(List<ExtendAttr> extendAttr) {
        this.extendAttr = extendAttr;
    }

    public BigDecimal getCodAmount() {
        return codAmount;
    }

    public void setCodAmount(BigDecimal codAmount) {
        this.codAmount = codAmount;
    }

    public Integer getIsCod() {
        return isCod;
    }

    public void setIsCod(Integer isCod) {
        this.isCod = isCod;
    }

    public List<SubsidyVoucher> getSubsidyAmountAndVoucherPrice() {
        return subsidyAmountAndVoucherPrice;
    }

    public void setSubsidyAmountAndVoucherPrice(List<SubsidyVoucher> subsidyAmountAndVoucherPrice) {
        this.subsidyAmountAndVoucherPrice = subsidyAmountAndVoucherPrice;
    }

    public ReceiverAddressInfo getReceiverAddressInfo() {
        return receiverAddressInfo;
    }

    public void setReceiverAddressInfo(ReceiverAddressInfo receiverAddressInfo) {
        this.receiverAddressInfo = receiverAddressInfo;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getPaypalEmail() {
        return paypalEmail;
    }

    public void setPaypalEmail(String paypalEmail) {
        this.paypalEmail = paypalEmail;
    }

    public Date getCloseDate() {
        return closeDate;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    public String getCustomerAbnnumber() {
        return customerAbnnumber;
    }

    public void setCustomerAbnnumber(String customerAbnnumber) {
        this.customerAbnnumber = customerAbnnumber;
    }

    public Integer getIsLotteryOrder() {
        return isLotteryOrder;
    }

    public void setIsLotteryOrder(Integer isLotteryOrder) {
        this.isLotteryOrder = isLotteryOrder;
    }

    public String getStreet1() {
        return street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public String getStreet2() {
        return street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public Integer getIsVirtual() {
        return isVirtual;
    }

    public void setIsVirtual(Integer isVirtual) {
        this.isVirtual = isVirtual;
    }

    public Integer getIsForecast() {
        return isForecast;
    }

    public void setIsForecast(Integer isForecast) {
        this.isForecast = isForecast;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getPhone1() {
        return phone1;
    }

    public void setPhone1(String phone1) {
        this.phone1 = phone1;
    }

    public String getPhone2() {
        return phone2;
    }

    public void setPhone2(String phone2) {
        this.phone2 = phone2;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getIsNewOrder() {
        return isNewOrder;
    }

    public void setIsNewOrder(Integer isNewOrder) {
        this.isNewOrder = isNewOrder;
    }

    public String getDoorcode() {
        return doorcode;
    }

    public void setDoorcode(String doorcode) {
        this.doorcode = doorcode;
    }

    public Integer getFbaFlag() {
        return fbaFlag;
    }

    public void setFbaFlag(Integer fbaFlag) {
        this.fbaFlag = fbaFlag;
    }

    public void setRefundFeeCurrencyId(String refundFeeCurrencyId) {
        this.refundFeeCurrencyId = refundFeeCurrencyId;
    }

    public BigDecimal getOriginFax() {
        return originFax;
    }

    public void setOriginFax(BigDecimal originFax) {
        this.originFax = originFax;
    }

    public String getBeforeStatus() {
        return beforeStatus;
    }

    public void setBeforeStatus(String beforeStatus) {
        this.beforeStatus = beforeStatus;
    }

    public Integer getBeforeCansend() {
        return beforeCansend;
    }

    public void setBeforeCansend(Integer beforeCansend) {
        this.beforeCansend = beforeCansend;
    }

    public BigDecimal getOtherExpend() {
        return otherExpend;
    }

    public void setOtherExpend(BigDecimal otherExpend) {
        this.otherExpend = otherExpend;
    }

    public BigDecimal getOtherIncome() {
        return otherIncome;
    }

    public void setOtherIncome(BigDecimal otherIncome) {
        this.otherIncome = otherIncome;
    }

    public BigDecimal getShippingChargeback() {
        return shippingChargeback;
    }

    public void setShippingChargeback(BigDecimal shippingChargeback) {
        this.shippingChargeback = shippingChargeback;
    }

    public BigDecimal getVariableClosingFee() {
        return variableClosingFee;
    }

    public void setVariableClosingFee(BigDecimal variableClosingFee) {
        this.variableClosingFee = variableClosingFee;
    }

    public BigDecimal getVatFee() {
        return vatFee;
    }

    public void setVatFee(BigDecimal vatFee) {
        this.vatFee = vatFee;
    }

    public BigDecimal getVatFeeOrigin() {
        return vatFeeOrigin;
    }

    public void setVatFeeOrigin(BigDecimal vatFeeOrigin) {
        this.vatFeeOrigin = vatFeeOrigin;
    }

    public BigDecimal getEvaluationFee() {
        return evaluationFee;
    }

    public void setEvaluationFee(BigDecimal evaluationFee) {
        this.evaluationFee = evaluationFee;
    }

    public BigDecimal getInsuranceFee() {
        return insuranceFee;
    }

    public void setInsuranceFee(BigDecimal insuranceFee) {
        this.insuranceFee = insuranceFee;
    }

    public BigDecimal getInsuranceFeeOrigin() {
        return insuranceFeeOrigin;
    }

    public void setInsuranceFeeOrigin(BigDecimal insuranceFeeOrigin) {
        this.insuranceFeeOrigin = insuranceFeeOrigin;
    }

    public BigDecimal getPaypalFee() {
        return paypalFee;
    }

    public void setPaypalFee(BigDecimal paypalFee) {
        this.paypalFee = paypalFee;
    }

    public BigDecimal getPaypalFeeOrigin() {
        return paypalFeeOrigin;
    }

    public void setPaypalFeeOrigin(BigDecimal paypalFeeOrigin) {
        this.paypalFeeOrigin = paypalFeeOrigin;
    }

    public BigDecimal getItemTotalCost() {
        return itemTotalCost;
    }

    public void setItemTotalCost(BigDecimal itemTotalCost) {
        this.itemTotalCost = itemTotalCost;
    }

    public BigDecimal getShippingCost() {
        return shippingCost;
    }

    public void setShippingCost(BigDecimal shippingCost) {
        this.shippingCost = shippingCost;
    }

    public BigDecimal getShippingPreCost() {
        return shippingPreCost;
    }

    public void setShippingPreCost(BigDecimal shippingPreCost) {
        this.shippingPreCost = shippingPreCost;
    }

    public BigDecimal getPackageFee() {
        return packageFee;
    }

    public void setPackageFee(BigDecimal packageFee) {
        this.packageFee = packageFee;
    }

    public BigDecimal getFbaPerOrderFulfillmentFee() {
        return fbaPerOrderFulfillmentFee;
    }

    public void setFbaPerOrderFulfillmentFee(BigDecimal fbaPerOrderFulfillmentFee) {
        this.fbaPerOrderFulfillmentFee = fbaPerOrderFulfillmentFee;
    }

    public BigDecimal getFbaCommission() {
        return fbaCommission;
    }

    public void setFbaCommission(BigDecimal fbaCommission) {
        this.fbaCommission = fbaCommission;
    }

    public BigDecimal getPromotionAmount() {
        return promotionAmount;
    }

    public void setPromotionAmount(BigDecimal promotionAmount) {
        this.promotionAmount = promotionAmount;
    }

    public BigDecimal getPromotionAmountOrigin() {
        return promotionAmountOrigin;
    }

    public void setPromotionAmountOrigin(BigDecimal promotionAmountOrigin) {
        this.promotionAmountOrigin = promotionAmountOrigin;
    }

    public BigDecimal getAllianceFeeOrigin() {
        return allianceFeeOrigin;
    }

    public void setAllianceFeeOrigin(BigDecimal allianceFeeOrigin) {
        this.allianceFeeOrigin = allianceFeeOrigin;
    }

    public BigDecimal getVoucherPriceOrigin() {
        return voucherPriceOrigin;
    }

    public void setVoucherPriceOrigin(BigDecimal voucherPriceOrigin) {
        this.voucherPriceOrigin = voucherPriceOrigin;
    }

    public BigDecimal getSubsidyAmountOrigin() {
        return subsidyAmountOrigin;
    }

    public void setSubsidyAmountOrigin(BigDecimal subsidyAmountOrigin) {
        this.subsidyAmountOrigin = subsidyAmountOrigin;
    }

    public BigDecimal getCodCharge() {
        return codCharge;
    }

    public void setCodCharge(BigDecimal codCharge) {
        this.codCharge = codCharge;
    }

    public BigDecimal getAllianceFee() {
        return allianceFee;
    }

    public void setAllianceFee(BigDecimal allianceFee) {
        this.allianceFee = allianceFee;
    }

    public BigDecimal getFbaPerUnitFulfillmentFee() {
        return fbaPerUnitFulfillmentFee;
    }

    public void setFbaPerUnitFulfillmentFee(BigDecimal fbaPerUnitFulfillmentFee) {
        this.fbaPerUnitFulfillmentFee = fbaPerUnitFulfillmentFee;
    }

    public BigDecimal getFbaWeightBasedFee() {
        return fbaWeightBasedFee;
    }

    public void setFbaWeightBasedFee(BigDecimal fbaWeightBasedFee) {
        this.fbaWeightBasedFee = fbaWeightBasedFee;
    }

    public BigDecimal getPlatformFeeOrigin() {
        return platformFeeOrigin;
    }

    public void setPlatformFeeOrigin(BigDecimal platformFeeOrigin) {
        this.platformFeeOrigin = platformFeeOrigin;
    }

    public BigDecimal getVoucherPrice() {
        return voucherPrice;
    }

    public void setVoucherPrice(BigDecimal voucherPrice) {
        this.voucherPrice = voucherPrice;
    }

    public BigDecimal getSubsidyAmount() {
        return subsidyAmount;
    }

    public void setSubsidyAmount(BigDecimal subsidyAmount) {
        this.subsidyAmount = subsidyAmount;
    }

    public Integer getIsWms() {
        return isWms;
    }

    public void setIsWms(Integer isWms) {
        this.isWms = isWms;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getVendorID() {
        return vendorID;
    }

    public void setVendorID(String vendorID) {
        this.vendorID = vendorID;
    }

    public String getAbnnumber() {
        return abnnumber;
    }

    public void setAbnnumber(String abnnumber) {
        this.abnnumber = abnnumber;
    }
}
