package com.thebeastshop.mbgw.sdk.model.order;


import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * 发票信息子模型
 */
public class InvoiceData implements Serializable {
    private static final long serialVersionUID = -6129623803792139097L;
    @JSONField(name = "invoice_status")
    private Integer invoiceStatus; // 发票状态（0开票中，1开票失败，2开票成功，3取消中，4取消失败，5已取消，6退票中，7退票失败，8已退票）

    @JSONField(name = "cos_danfe_url")
    private String cosDanfeUrl; // DANFE

    @JSONField(name = "cos_danfe_simples")
    private String cosDanfeSimples; // 简易DANFE

    @JSONField(name = "cos_danfe_etiqueta")
    private String cosDanfeEtiqueta; // 简易DANFE-面单格式

    @JSONField(name = "cos_danfe_simples_no_amount")
    private String cosDanfeSimplesNoAmount; // 简易DANFE-无金额面单格式

    // Getter/Setter
    public Integer getInvoiceStatus() { return invoiceStatus; }
    public void setInvoiceStatus(Integer invoiceStatus) { this.invoiceStatus = invoiceStatus; }
    public String getCosDanfeUrl() { return cosDanfeUrl; }
    public void setCosDanfeUrl(String cosDanfeUrl) { this.cosDanfeUrl = cosDanfeUrl; }
    public String getCosDanfeSimples() { return cosDanfeSimples; }
    public void setCosDanfeSimples(String cosDanfeSimples) { this.cosDanfeSimples = cosDanfeSimples; }
    public String getCosDanfeEtiqueta() { return cosDanfeEtiqueta; }
    public void setCosDanfeEtiqueta(String cosDanfeEtiqueta) { this.cosDanfeEtiqueta = cosDanfeEtiqueta; }
    public String getCosDanfeSimplesNoAmount() { return cosDanfeSimplesNoAmount; }
    public void setCosDanfeSimplesNoAmount(String cosDanfeSimplesNoAmount) { this.cosDanfeSimplesNoAmount = cosDanfeSimplesNoAmount; }
}