/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.utils.ExcelRowCellTemplate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExcelRowTemplate
implements Serializable {
    private int rowNum;
    private boolean insertRow = false;
    private boolean isAutoRowHeight = false;
    private List<ExcelRowCellTemplate> cells;

    public ExcelRowTemplate() {
    }

    public ExcelRowTemplate(int rowIndex) {
        this.rowNum = rowIndex;
    }

    public ExcelRowTemplate(int rowIndex, List<String> lines) {
        this.rowNum = rowIndex;
        this.cells = new ArrayList<ExcelRowCellTemplate>();
        this.buildCells(lines);
    }

    private void buildCells(List<String> lines) {
        if (lines == null || lines.size() == 0) {
            return;
        }
        int lineSize = lines.size();
        for (int i = 0; i < lineSize; ++i) {
            String cellValue = lines.get(i);
            this.cells.add(new ExcelRowCellTemplate(this.rowNum, i, cellValue));
        }
    }

    public List<ExcelRowCellTemplate> getCells() {
        return this.cells;
    }

    public void setCells(List<ExcelRowCellTemplate> cells) {
        this.cells = cells;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public boolean isInsertRow() {
        return this.insertRow;
    }

    public void setInsertRow(boolean insertRow) {
        this.insertRow = insertRow;
    }

    public boolean isAutoRowHeight() {
        return this.isAutoRowHeight;
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        this.isAutoRowHeight = autoRowHeight;
    }
}

