/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.utils.ErrorMessage;
import com.thebeastshop.common.utils.ExcelColumn;
import com.thebeastshop.common.utils.ExcelSheet;
import com.thebeastshop.common.utils.ExcelTemplate;
import com.thebeastshop.common.utils.MultSheetWriteExcel;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jxl.CellView;
import jxl.JXLException;
import jxl.Workbook;
import jxl.biff.FontRecord;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;

@Component(value="advancedWriteExcel")
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class AdvancedWriteExcel
implements MultSheetWriteExcel {
    protected List<String> errorMessages = new ArrayList<String>();
    public static String FILE_PATH = File.separator + "data" + File.separator + "appdatas";
    protected final SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected final SimpleDateFormat isoTimeFormat = new SimpleDateFormat("hh:mm:ss.SSSZ");
    protected final SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected final SimpleDateFormat dateTimeFormatForFileName = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
    protected WritableCellFormat boldText;
    protected WritableCellFormat normalText;
    protected File file;

    @Override
    public byte[] write(Map<Class<?>, List<?>> sheetMap) {
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> cellFormats = new ArrayList<String>();
        ArrayList<Field> ecFields = new ArrayList<Field>();
        Method getErrorMsgMethod = null;
        try {
            File file = this.createTmpFile();
            WritableWorkbook workbook = Workbook.createWorkbook((File)file);
            WritableFont boldFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
            boldFont.setPointSize(11);
            WritableFont normalFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
            normalFont.setPointSize(11);
            this.boldText = new WritableCellFormat(boldFont);
            this.normalText = new WritableCellFormat(normalFont);
            int idx = 0;
            for (Map.Entry<Class<?>, List<?>> entry : sheetMap.entrySet()) {
                Class<?> clazz = entry.getKey();
                List<?> datas = entry.getValue();
                WritableSheet sheet = this.createSheet(clazz, workbook, idx++);
                headers.clear();
                ecFields.clear();
                cellFormats.clear();
                this.initHeadersAndEcFields(clazz, headers, ecFields, cellFormats);
                if (this.hasError()) break;
                this.writeHeader(sheet, headers, cellFormats);
                getErrorMsgMethod = this.initErrorMessageMehtod(clazz);
                this.writeContent(clazz, getErrorMsgMethod, sheet, ecFields, datas);
            }
            workbook.write();
            workbook.close();
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getErrors() {
        return this.errorMessages;
    }

    @Override
    public boolean hasError() {
        return this.errorMessages.size() > 0;
    }

    private void initHeadersAndEcFields(Class<?> clazz, List<String> headers, List<Field> ecFields, List<String> cellFormats) {
        ExcelColumn ec;
        ExcelTemplate et = clazz.getAnnotation(ExcelTemplate.class);
        if (et == null) {
            this.errorMessages.add(clazz.getName() + "\u4e0d\u662fexcel\u6a21\u677f\u7c7b!");
            return;
        }
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Class<?> temp = clazz; temp != null && !temp.equals(Object.class) && temp.getAnnotation(ExcelTemplate.class) != null; temp = temp.getSuperclass()) {
            Field[] fs = temp.getDeclaredFields();
            for (int x = 0; x < fs.length; ++x) {
                ec = fs[x].getAnnotation(ExcelColumn.class);
                if (ec == null) continue;
                fieldsList.add(fs[x]);
            }
        }
        for (int i = 0; i < fieldsList.size(); ++i) {
            Field tfield = (Field)fieldsList.get(i);
            ec = tfield.getAnnotation(ExcelColumn.class);
            if (ec == null) continue;
            String columnName = ec.name().equals("") ? tfield.getName() : ec.name();
            String cellFormat = ec.cellFormat();
            ecFields.add(tfield);
            headers.add(columnName);
            cellFormats.add(cellFormat);
        }
        if (headers.size() < 1) {
            this.errorMessages.add("\u6ca1\u6709\u627e\u5230ExcelColumn!\u8bf7\u68c0\u67e5\u6a21\u677f\u7c7b!");
            return;
        }
    }

    private int writeHeader(WritableSheet s, List<String> headers, List<String> cellFormats) throws RowsExceededException, JXLException {
        int row = 0;
        for (int i = 0; i < headers.size(); ++i) {
            Label l = new Label(i, 0, headers.get(i), (CellFormat)this.boldText);
            s.addCell((WritableCell)l);
            if (cellFormats.get(i) == null || !"TEXT".equals(cellFormats.get(i))) continue;
            WritableFont normalFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
            normalFont.setPointSize(11);
            WritableCellFormat normalText = new WritableCellFormat(NumberFormats.TEXT);
            normalText.setFont((FontRecord)normalFont);
            CellView cv = new CellView();
            cv.setFormat((CellFormat)normalText);
            cv.setSize(5300);
            s.setColumnView(i, cv);
        }
        return row + 1;
    }

    private int writeContent(Class<?> clazz, Method getErrorMsgMethod, WritableSheet s, List<Field> ecFields, List<?> datas) {
        if (datas == null) {
            return 0;
        }
        try {
            for (int i = 0; i < datas.size(); ++i) {
                if (ecFields != null && ecFields.size() > 0) {
                    for (int j = 0; j < ecFields.size(); ++j) {
                        Method method = clazz.getMethod(this.generateGetMethod(ecFields.get(j).getName()), new Class[0]);
                        Object obj = method.invoke(datas.get(i), new Object[0]);
                        if (obj instanceof java.lang.Number) {
                            java.lang.Number value = null;
                            if (obj != null) {
                                value = (java.lang.Number)obj;
                            }
                            Number n = new Number(j, i + 1, value.doubleValue());
                            s.addCell((WritableCell)n);
                            continue;
                        }
                        Label l = null;
                        if (obj != null && ecFields.get(j).getType().getName().equals("java.util.Date")) {
                            DateTimeFormat dtf = ecFields.get(j).getAnnotation(DateTimeFormat.class);
                            if (dtf == null || dtf.iso().equals((Object)DateTimeFormat.ISO.NONE)) {
                                l = new Label(j, i + 1, this.isoDateFormat.format((Date)obj), (CellFormat)this.normalText);
                            } else {
                                String df = this.chooseISODateFormat(dtf.iso(), (Date)obj);
                                l = new Label(j, i + 1, df, (CellFormat)this.normalText);
                            }
                        } else {
                            l = new Label(j, i + 1, obj == null ? "" : obj.toString(), (CellFormat)this.normalText);
                        }
                        s.addCell((WritableCell)l);
                    }
                } else {
                    Object[] data = (Object[])datas.get(i);
                    for (int j = 0; j < data.length; ++j) {
                        Label l = null;
                        l = new Label(j, i + 1, data[j] == null ? "" : data[j].toString(), (CellFormat)this.normalText);
                        s.addCell((WritableCell)l);
                    }
                }
                if (this.getErrorMessage(datas.get(i), getErrorMsgMethod).length() <= 0) continue;
                Label l = new Label(ecFields.size(), i + 1, this.getErrorMessage(datas.get(i), getErrorMsgMethod), (CellFormat)this.normalText);
                s.addCell((WritableCell)l);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (JxlWriteException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected Method initErrorMessageMehtod(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                ErrorMessage em = fields[i].getAnnotation(ErrorMessage.class);
                if (em == null) continue;
                return clazz.getMethod(this.generateGetMethod(fields[i].getName()), new Class[0]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String generateGetMethod(String fieldName) {
        if (fieldName == null || fieldName.length() < 1) {
            return "";
        }
        return "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
    }

    private File createTmpFile() {
        String fileName = this.dateTimeFormatForFileName.format(new Date()) + ".xls";
        File path = new File(FILE_PATH + File.separator + "import_invalid_excel" + File.separator);
        return new File(path, fileName);
    }

    private WritableSheet createSheet(Class<?> clazz, WritableWorkbook workbook, int idx) {
        ExcelSheet es = clazz.getAnnotation(ExcelSheet.class);
        String name = es.value();
        int index = es.index();
        if (index == 0) {
            index = idx;
        }
        if (name == null || name == "") {
            name = "sheet" + index;
        }
        return workbook.createSheet(name, index);
    }

    protected String getErrorMessage(Object obj, Method getErrorMsgMethod) {
        if (getErrorMsgMethod != null) {
            try {
                Object value = getErrorMsgMethod.invoke(obj, new Object[0]);
                return value == null ? "" : value.toString();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected String chooseISODateFormat(DateTimeFormat.ISO iso, Date date) {
        if (iso.equals((Object)DateTimeFormat.ISO.DATE)) {
            return this.isoDateFormat.format(date);
        }
        if (iso.equals((Object)DateTimeFormat.ISO.TIME)) {
            return this.isoTimeFormat.format(date);
        }
        if (iso.equals((Object)DateTimeFormat.ISO.DATE_TIME)) {
            return this.isoDateTimeFormat.format(date);
        }
        return "yyyy-MM-dd";
    }
}

