/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.http;

import com.thebeastshop.common.http.HttpRequest;
import com.thebeastshop.common.http.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private String charset = "UTF-8";
    protected CloseableHttpClient httpClient = HttpClients.createDefault();

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected HttpGet initGetMethod(HttpRequest req) {
        return this.initGetMethod(req, null);
    }

    protected HttpGet initGetMethod(HttpRequest req, List<Header> headers) {
        String cookies;
        String host;
        String url = req.getUrl();
        String params = req.getParams();
        if (url.indexOf("?") == -1 && params != null && !"".equals(params)) {
            url = url + "?" + params;
        }
        HttpGet getMethod = new HttpGet(url);
        getMethod.addHeader("Connection", "Keep-Alive");
        getMethod.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/32.0.1700.6 Safari/537.36");
        getMethod.setHeader("Accept", "*/*");
        if (headers != null) {
            for (Header header : headers) {
                getMethod.addHeader(header);
            }
        }
        if ((host = req.getHost()) != null && !"".equals(host)) {
            getMethod.addHeader("Host", host);
            if (getMethod.getHeaders("Referer") == null) {
                getMethod.addHeader("Referer", "http://" + host + "/");
            }
        }
        if ((cookies = req.getCookieStr()) != null && !"".equals(cookies)) {
            getMethod.addHeader("Cookie", cookies);
        }
        return getMethod;
    }

    protected HttpPost initPostMethod(HttpRequest req) {
        return this.initPostMethod(req, null);
    }

    protected HttpPost initPostMethod(HttpRequest req, List<Header> headers) {
        String params;
        String cookies;
        String host;
        HttpPost postMethod = new HttpPost(req.getUrl());
        postMethod.addHeader("Connection", "Keep-Alive");
        postMethod.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/32.0.1700.6 Safari/537.36");
        postMethod.setHeader("Accept", "*/*");
        if (headers != null) {
            for (Header header : headers) {
                postMethod.addHeader(header);
            }
        }
        if ((host = req.getHost()) != null && !"".equals(host)) {
            postMethod.addHeader("Host", host);
            if (postMethod.getHeaders("Referer") == null) {
                postMethod.addHeader("Referer", "http://" + host + "/");
            }
        }
        if ((cookies = req.getCookieStr()) != null && !"".equals(cookies) && cookies != null && !"".equals(cookies)) {
            postMethod.addHeader("Cookie", cookies);
        }
        if ((params = req.getParams()) != null && !"".equals(params)) {
            String[] _params = params.split("&");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (int i = 0; i < _params.length; ++i) {
                String _p = _params[i];
                int j = _p.indexOf("=");
                nvps.add(new BasicNameValuePair(_p.substring(0, j), _p.length() > j + 1 ? _p.substring(j + 1) : ""));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, Consts.UTF_8);
            postMethod.setEntity((HttpEntity)entity);
        }
        return postMethod;
    }

    protected Map<String, String> getCookiesByResponseHeaders(HeaderIterator headerIterator) {
        HashMap<String, String> m = new HashMap<String, String>();
        while (headerIterator.hasNext()) {
            Header header = (Header)headerIterator.next();
            if (!"Set-Cookie".equals(header.getName())) continue;
            for (String s : header.getValue().split(";")) {
                int i = (s = s.trim()).indexOf("=");
                if (i == -1) continue;
                m.put(s.substring(0, i), s.length() > i + 1 ? s.substring(i + 1) : "");
            }
        }
        return m;
    }

    protected Map<String, String> getHeadersByResponseHeaders(HeaderIterator headerIterator) {
        HashMap<String, String> m = new HashMap<String, String>();
        while (headerIterator.hasNext()) {
            Header header = (Header)headerIterator.next();
            if ("Set-Cookie".equals(header.getName())) continue;
            m.put(header.getName(), header.getValue());
        }
        return m;
    }

    public HttpResponse request(HttpRequest req) throws HttpException, IOException {
        return this.request(req, null);
    }

    public HttpResponse request(HttpRequest req, List<Header> headers) throws HttpException, IOException {
        return this.request(req, headers, 200);
    }

    public HttpResponse request(HttpRequest req, int successStatus) throws HttpException, IOException {
        return this.request(req, null, successStatus);
    }

    public HttpResponse request(HttpRequest req, List<Header> headers, int successStatus) throws HttpException, IOException {
        return this.request(req, headers, successStatus, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse request(HttpRequest req, List<Header> headers, int successStatus, boolean isPost) throws HttpException, IOException {
        HttpResponse resp;
        block13: {
            HttpPost httpMethod = isPost ? this.initPostMethod(req, headers) : this.initGetMethod(req, headers);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(req.getSoTimeout()).setConnectTimeout(req.getTimeOut()).build();
            httpMethod.setConfig(requestConfig);
            resp = new HttpResponse();
            CloseableHttpResponse response = null;
            try {
                response = this.httpClient.execute((HttpUriRequest)httpMethod);
                int statusCode = response.getStatusLine().getStatusCode();
                this.logger.debug("request statusCode:" + statusCode + "," + req.getUrl());
                resp.setStatusCode(statusCode);
                if (successStatus == -1 || statusCode == successStatus) {
                    if (req.isNeedCookie()) {
                        Map<String, String> _cookies = this.getCookiesByResponseHeaders(response.headerIterator());
                        resp.setCookieMap(_cookies);
                    }
                    if (req.isNeedHeaderMap()) {
                        Map<String, String> _headers = this.getHeadersByResponseHeaders(response.headerIterator());
                        resp.setHeaderMap(_headers);
                    }
                    HttpEntity entity = response.getEntity();
                    if (req.isNeedBody()) {
                        boolean isGzip;
                        Header contentType = entity.getContentType();
                        Header contentEncoding = entity.getContentEncoding();
                        boolean bl = isGzip = contentEncoding != null && contentEncoding.getValue().toLowerCase().indexOf("gzip") > -1;
                        if (contentType != null && this.needWrap(contentType.getValue())) {
                            resp.setBody(this.getResBody(entity, isGzip));
                        } else {
                            resp.setByteBody(this.getResByteBody(entity, isGzip));
                        }
                    }
                    break block13;
                }
                throw new RuntimeException("request failed(status):" + statusCode + "/" + successStatus + "," + req.getUrl());
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (httpMethod != null) {
                    httpMethod.releaseConnection();
                }
            }
        }
        return resp;
    }

    public void requestNoResp(HttpRequest req) throws HttpException, IOException {
        this.requestNoResp(req, null);
    }

    public void requestNoResp(HttpRequest req, List<Header> headers) throws HttpException, IOException {
        this.requestNoResp(req, headers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNoResp(HttpRequest req, List<Header> headers, boolean isPost) throws HttpException, IOException {
        HttpPost httpMethod = isPost ? this.initPostMethod(req, headers) : this.initGetMethod(req, headers);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(req.getSoTimeout()).setConnectTimeout(req.getTimeOut()).build();
        httpMethod.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            this.logger.debug("requestNoResp statusCode:" + statusCode + "," + req.getUrl());
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    private boolean needWrap(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.contains("text/xml") || contentType.contains("text/html") || contentType.contains("text/css") || contentType.contains("javascript") || contentType.contains("application/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResBody(HttpEntity entity, boolean isGzip) throws IOException {
        StringBuilder sb = new StringBuilder(128);
        InputStream is = null;
        try {
            is = isGzip ? new GZIPInputStream(entity.getContent()) : entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, this.charset));
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception e) {
            this.logger.warn(e.toString());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.warn(e.toString());
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResByteBody(HttpEntity entity, boolean isGzip) {
        InputStream is = null;
        ArrayList<Byte> resList = null;
        try {
            resList = new ArrayList<Byte>();
            is = isGzip ? new GZIPInputStream(entity.getContent()) : entity.getContent();
            byte[] b = new byte[1];
            while (is.read(b) != -1) {
                resList.add(new Byte(b[0]));
                b = new byte[1];
            }
        }
        catch (Exception e) {
            this.logger.warn(e.toString());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.warn(e.toString());
                }
            }
        }
        byte[] res = new byte[resList.size()];
        for (int i = 0; i < resList.size(); ++i) {
            res[i] = (Byte)resList.get(i);
        }
        return res;
    }
}

