/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * CSV读写工具
 *
 * @author Royan
 * @version $Id: CSVUtil.java, v 0.1 2015-07-07 上午10:44
 */
public class CSVUtil {

    private final static Logger log               = LoggerFactory.getLogger(CSVUtil.class);

    public static final char    ESCAPE_CHARACTER  = '"';

    public static final char    DEFAULT_SEPARATOR = ',';

    public static final String  DEFAULT_LINE_END  = "\n";

    private static final String DEFAULT_ENCODING  = "GB18030";

    public static byte[] write(List<List<String>> allLines) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw;
        try {
            pw = new PrintWriter(new OutputStreamWriter(os, DEFAULT_ENCODING));
        } catch (UnsupportedEncodingException e) {
            log.warn("", e);
            return null;
        }

        for (List<String> nextLine : allLines) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nextLine.size(); i++) {
                if (i != 0) {
                    sb.append(DEFAULT_SEPARATOR);
                }

                String nextElement = nextLine.get(i);
                if (nextElement == null) {
                    continue;
                }

                sb.append(ESCAPE_CHARACTER);
                for (int j = 0; j < nextElement.length(); j++) {
                    char nextChar = nextElement.charAt(j);
                    if (nextChar == ESCAPE_CHARACTER) {
                        sb.append(ESCAPE_CHARACTER).append(nextChar);
                    } else {
                        sb.append(nextChar);
                    }
                }
                sb.append(ESCAPE_CHARACTER);
            }

            sb.append(DEFAULT_LINE_END);
            pw.write(sb.toString());
        }
        pw.flush();
        pw.close();
        try {
            os.close();
        } catch (IOException e) {
            log.warn("", e);
            throw new RuntimeException("Write CSV File Error");
        }
        return os.toByteArray();
    }

    public static List<List<String>> read(InputStream is) {
        List<List<String>> allLines = new ArrayList<>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is, DEFAULT_ENCODING));

            String nextLine;
            while ((nextLine = br.readLine()) != null) {
                List<String> line = new ArrayList<>();
                for (String element : nextLine.split(DEFAULT_SEPARATOR + "")) {
                    if (element.startsWith(ESCAPE_CHARACTER + "")) {
                        if (element.length() <= 2 || !element.startsWith(ESCAPE_CHARACTER + "")
                            || !element.endsWith(ESCAPE_CHARACTER + "")) {
                            continue;
                        }
                        element = element.substring(1, element.length() - 1).replaceAll(
                            ESCAPE_CHARACTER + ESCAPE_CHARACTER + "", ESCAPE_CHARACTER + "");
                        line.add(element);
                    } else {
                        line.add(element);
                    }
                }
                allLines.add(line);
            }

        } catch (UnsupportedEncodingException e) {
            log.warn("", e);
            return null;
        } catch (IOException e) {
            log.warn("", e);
            return null;
        } finally {
            try {
                br.close();
            } catch (IOException e) {
                log.warn("", e);
                return null;
            }
        }

        return allLines;
    }
}
