/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.cat;

import com.dianping.cat.configuration.ApplicationEnvironment;
import com.dianping.cat.configuration.AtomicTreeParser;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.ProblemLongType;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import com.dianping.cat.configuration.property.entity.PropertyConfig;
import com.dianping.cat.message.spi.MessageTree;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.unidal.helper.Properties;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.util.StringUtils;
import org.xml.sax.SAXException;

@Named(type=ClientConfigManager.class)
public class BeastClientConfigManager
implements LogEnabled,
ClientConfigManager,
Initializable {
    private ClientConfig m_config;
    private volatile double m_samplingRate = 1.0;
    private volatile boolean m_block = false;
    private String m_routers;
    private AtomicTreeParser m_atomicTreeParser = new AtomicTreeParser();
    private Map<String, Integer> m_longConfigs = new LinkedHashMap<String, Integer>();
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public String getDomain() {
        return this.m_config != null ? this.m_config.getDomain() : "unknown";
    }

    public int getLongConfigThreshold(String key) {
        Integer value = this.m_longConfigs.get(key);
        if (value == null || value == 0) {
            value = ProblemLongType.findByName((String)key).getThreshold();
        }
        return value;
    }

    public int getMaxMessageChildren() {
        return this.m_config == null ? 5000 : this.m_config.getMaxMessageSize();
    }

    public String getRouters() {
        if (this.m_routers == null) {
            this.refreshConfig();
        }
        return this.m_routers;
    }

    public double getSamplingRate() {
        return this.m_samplingRate;
    }

    private String getServerConfigUrl(ClientConfig config, int start, int retry) {
        List servers;
        int size;
        int index;
        if (config == null) {
            return null;
        }
        String ip = null;
        Integer httpPort = null;
        if (this.m_routers != null) {
            ip = this.parseServerIp(this.m_routers);
        }
        if ((index = (start + retry) % (size = (servers = config.getServers()).size())) >= 0 && index < size) {
            Server server = (Server)servers.get(index);
            httpPort = server.getHttpPort();
            if (ip == null) {
                ip = server.getIp();
            }
        }
        if (httpPort == null || httpPort == 0) {
            httpPort = 8080;
        }
        return ip != null ? String.format("http://%s:%d/cat/s/router?domain=%s&ip=%s&op=xml&env=%s", ip.trim(), httpPort, this.getDomain(), NetworkInterfaceManager.INSTANCE.getLocalHostAddress(), ApplicationEnvironment.ENVIRONMENT) : null;
    }

    public List<Server> getServers() {
        return this.m_config == null ? Collections.emptyList() : this.m_config.getServers();
    }

    public void initialize() {
        String config = System.getProperty("cat-client-config");
        if (StringUtils.isNotEmpty((String)config)) {
            try {
                ClientConfig clientConfig = DefaultSaxParser.parse((String)config);
                this.initialize(clientConfig);
            }
            catch (Exception var3) {
                this.m_logger.error("error in client config " + config, (Throwable)var3);
                this.initializeWithDefault();
            }
        } else {
            this.initializeWithDefault();
        }
    }

    public void initialize(ClientConfig config) {
        try {
            if (config != null) {
                this.m_config = config;
                this.m_logger.info("setup cat with config:" + config);
            }
        }
        catch (Exception var3) {
            this.m_logger.error(var3.getMessage(), (Throwable)var3);
            this.m_config = new ClientConfig();
        }
    }

    private void initializeWithDefault() {
        String appName = ApplicationEnvironment.loadAppName((String)"unknown");
        try {
            ClientConfig config = ApplicationEnvironment.loadClientConfig((String)appName);
            config.setDomain(appName);
            this.m_config = config;
            this.m_logger.info("setup cat with default config:" + this.m_config);
        }
        catch (Exception var3) {
            this.m_logger.error("error when init cat", (Throwable)var3);
            this.m_config = new ClientConfig(appName);
        }
    }

    public boolean isAtomicMessage(MessageTree tree) {
        return tree.canDiscard() && this.m_atomicTreeParser.isAtomicMessage(tree);
    }

    private boolean isDevMode() {
        String devMode = (String)Properties.forString().fromEnv().fromSystem().getProperty("devMode", (Object)"false");
        return "true".equals(devMode);
    }

    public boolean isMessageBlock() {
        return this.m_block;
    }

    private int parseInteger(PropertyConfig config, String key, int defaultValue) {
        String value = config.findProperty(key).getValue();
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private String parseServerIp(String content) {
        try {
            List strs = Splitters.by((String)";").noEmptyItem().split(content);
            Iterator var3 = strs.iterator();
            if (var3.hasNext()) {
                String str = (String)var3.next();
                List items = Splitters.by((String)":").noEmptyItem().split(str);
                return (String)items.get(0);
            }
        }
        catch (Exception var6) {
            this.m_logger.error(var6.getMessage(), (Throwable)var6);
        }
        return null;
    }

    public void refreshConfig() {
        String xml;
        int retry;
        int start = (int)Math.random() * 10;
        int maxRetryCount = 3;
        boolean refreshStatus = false;
        for (retry = 0; retry < maxRetryCount; ++retry) {
            xml = this.getServerConfigUrl(this.m_config, start, retry);
            try {
                this.refreshWithUrl(xml);
                refreshStatus = true;
                break;
            }
            catch (Exception var9) {
                this.m_logger.warn("error when connect cat server config url " + xml);
                continue;
            }
        }
        if (!refreshStatus && !this.isDevMode()) {
            try {
                xml = ApplicationEnvironment.loadRemoteClientConfig();
                ClientConfig config = DefaultSaxParser.parse((String)xml);
                config.setDomain(this.getDomain());
                String url = this.getServerConfigUrl(config, start, 0);
                this.refreshWithUrl(url);
            }
            catch (Exception var8) {
                ++retry;
                this.m_logger.warn("error when connect cat server config url from remote config");
            }
        }
    }

    private void refreshWithUrl(String url) throws IOException, SAXException {
        this.m_logger.info("cat refresh override");
    }

    public void setSample(double sample) {
        this.m_samplingRate = sample;
    }
}

