/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.converter;

import com.thebeastshop.common.converter.BeanConverterFieldFilter;
import com.thebeastshop.common.converter.BeanConverterHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.MapUtils;

public class BeanConverterHandlerManager<Source, Target> {
    private Set<String> ignoreFields = new HashSet<String>();
    private Map<String, BeanConverterFieldFilter<Source>> fieldFilterMap = new HashMap<String, BeanConverterFieldFilter<Source>>();
    private BeanConverterHandler<Source, Target> onCopy;
    private BeanConverterHandler<Source, Target> afterCopy;

    public synchronized BeanConverterHandlerManager ignore(String filedName) {
        this.ignoreFields.add(filedName);
        return this;
    }

    @Deprecated
    public synchronized BeanConverterHandlerManager addFieldFilter(String fieldName, BeanConverterFieldFilter<Source> filter) {
        this.ignore(fieldName);
        this.fieldFilterMap.put(fieldName, filter);
        return this;
    }

    public synchronized BeanConverterHandlerManager afterCopy(BeanConverterHandler<Source, Target> converterHandler) {
        this.afterCopy = converterHandler;
        return this;
    }

    public String[] getIgnoreFields() {
        String[] arr = null;
        if (!this.ignoreFields.isEmpty()) {
            arr = new String[this.ignoreFields.size()];
            int i = 0;
            for (String fieldName : this.ignoreFields) {
                arr[i++] = fieldName;
            }
        }
        return arr;
    }

    public BeanConverterHandler getOnConverter() {
        return this.onCopy;
    }

    public void setOnConverter(BeanConverterHandler onConverter) {
        this.onCopy = onConverter;
    }

    public BeanConverterHandler getAfterCopy() {
        return this.afterCopy;
    }

    public void setAfterCopy(BeanConverterHandler afterCopy) {
        this.afterCopy = afterCopy;
    }

    public void afterCopyProperties(Source sourceObj, Target targetObj) {
        if (MapUtils.isNotEmpty(this.fieldFilterMap)) {
            for (String fieldName : this.fieldFilterMap.keySet()) {
                BeanConverterFieldFilter<Source> fieldFilter = this.fieldFilterMap.get(fieldName);
                if (fieldFilter == null) continue;
                Object value = fieldFilter.fieldValueFrom(sourceObj);
                try {
                    BeanUtils.setProperty(targetObj, (String)fieldName, (Object)value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.afterCopy != null) {
            this.afterCopy.copyFields(sourceObj, targetObj);
        }
    }
}

