package com.thebeastshop.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 生日礼状态枚举
 * @author LK
 *
 */
public enum JumpTypeEnum {
	ARTICLE(1, "专题ID"),
	LIST(2, "列表ID"),
	CATEGORY(3, "分类ID"),
	BRAND(4, "品牌ID"),
	PRODUCT(5, "商品Code"),
	STORY(6, "封面故事"),
	GROUP(7, "团购"),
	MY(8, "我的"),
	PRIVILEGE(9, "我的特权"),
	POINT(10, "积分兑换")
	;

	public final Integer status;
	public final String desc;

	public static final List<JumpTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private JumpTypeEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (JumpTypeEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
