package com.thebeastshop.common.enums;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-04-17 11:27
 */
public enum CancelEnum implements CodeEnum<Integer>, BooleanValue {
    ACTIVE(0, "有效"),
    INACTIVE(1, "无效"),
    ;
    private Integer code;
    private String name;

    CancelEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Boolean toBooleanValue() {
        return code == 0 ? false : true;
    }
}
