/*
 * Decompiled with CFR 0.152.
 */
package com.thebeast.kit.alitool;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DoMetaQueryRequest;
import com.aliyun.oss.model.DoMetaQueryResult;
import com.aliyun.oss.model.ObjectFile;
import com.aliyun.oss.model.SortOrder;
import com.aliyun.oss.model.Tagging;
import com.aliyun.oss.model.UserMeta;
import com.thebeast.kit.alitool.FileQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSFileAdvancedFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSSFileAdvancedFilter.class);
    private OSSClient ossClient;
    private String ossEndPoint = "http://oss-cn-hangzhou-internal.aliyuncs.com";
    private String ossAccessId = "LTAI5tFG4ZZX3on1HLzAT431";
    private String ossAccessKey = "tab0iCLbT0CUbClG1KX5wltyYfLwjY";
    private String ossBucketName = "beast-finance";
    private String baseUrl;

    public OSSClient getOssClient() {
        if (this.ossClient == null) {
            this.ossClient = new OSSClient(this.ossEndPoint, this.ossAccessId, this.ossAccessKey);
        }
        return this.ossClient;
    }

    public String getOssEndPoint() {
        return this.ossEndPoint;
    }

    public void setOssEndPoint(String ossEndPoint) {
        this.ossEndPoint = ossEndPoint;
    }

    public String getOssAccessId() {
        return this.ossAccessId;
    }

    public void setOssAccessId(String ossAccessId) {
        this.ossAccessId = ossAccessId;
    }

    public String getOssAccessKey() {
        return this.ossAccessKey;
    }

    public void setOssAccessKey(String ossAccessKey) {
        this.ossAccessKey = ossAccessKey;
    }

    public String getOssBucketName() {
        return this.ossBucketName;
    }

    public void setOssBucketName(String ossBucketName) {
        this.ossBucketName = ossBucketName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileList(FileQuery fileQuery) {
        try {
            int maxResults = 100;
            String query = "{\n  \"SubQueries\":[\n    {\n      \"Field\":\"FileModifiedTime\",\n      \"Value\": \"2023-12-01T00:00:00.000+08:00\",\n      \"Operation\":\"gt\"\n    },         \n    {\n      \"Field\":\"FileModifiedTime\",\n      \"Value\": \"2024-03-31T23:59:59.000+08:00\",\n      \"Operation\":\"lt\"\n    }\n  ],\n  \"Operation\":\"and\"\n}";
            query = JSON.toJSONString((Object)query);
            String sort = "Filename";
            DoMetaQueryRequest doMetaQueryRequest = new DoMetaQueryRequest(this.ossBucketName, maxResults, query, sort);
            doMetaQueryRequest.setOrder(SortOrder.ASC);
            DoMetaQueryResult doMetaQueryResult = this.getOssClient().doMetaQuery(doMetaQueryRequest);
            if (doMetaQueryResult.getFiles() != null) {
                for (ObjectFile file : doMetaQueryResult.getFiles().getFile()) {
                    LOGGER.info("Filename: " + file.getFilename());
                    System.out.println("ETag: " + file.getETag());
                    System.out.println("ObjectACL: " + file.getObjectACL());
                    System.out.println("OssObjectType: " + file.getOssObjectType());
                    System.out.println("OssStorageClass: " + file.getOssStorageClass());
                    System.out.println("TaggingCount: " + file.getOssTaggingCount());
                    if (file.getOssTagging() != null) {
                        for (Tagging tag : file.getOssTagging().getTagging()) {
                            System.out.println("Key: " + tag.getKey());
                            System.out.println("Value: " + tag.getValue());
                        }
                    }
                    if (file.getOssUserMeta() == null) continue;
                    for (UserMeta meta : file.getOssUserMeta().getUserMeta()) {
                        System.out.println("Key: " + meta.getKey());
                        System.out.println("Value: " + meta.getValue());
                    }
                }
            }
        }
        catch (OSSException oe) {
            System.out.println("Error Message:" + oe.getErrorMessage());
            System.out.println("Error Code:" + oe.getErrorCode());
            System.out.println("Request ID:" + oe.getRequestId());
            System.out.println("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            LOGGER.error("Error Message: " + ce.getMessage());
        }
        finally {
            this.ossClient.shutdown();
        }
        return new ArrayList<String>();
    }

    public static void main(String[] args) {
        FileQuery fileQuery = new FileQuery();
        fileQuery.setOperation("and");
        ArrayList<FileQuery.SubQueriesDTO> subQueries = new ArrayList<FileQuery.SubQueriesDTO>();
        FileQuery.SubQueriesDTO subQueriesDTO_1 = new FileQuery.SubQueriesDTO();
        subQueriesDTO_1.setField("FileModifiedTime");
        subQueriesDTO_1.setOperation("gt");
        subQueriesDTO_1.setValue("2025-07-11T00:00:00.000+08:00");
        subQueries.add(subQueriesDTO_1);
        FileQuery.SubQueriesDTO subQueriesDTO_2 = new FileQuery.SubQueriesDTO();
        subQueriesDTO_2.setField("FileModifiedTime");
        subQueriesDTO_2.setOperation("lt");
        subQueriesDTO_2.setValue("2025-07-12T23:59:59.000+08:00");
        subQueries.add(subQueriesDTO_2);
        FileQuery.SubQueriesDTO subQueriesDTO_3 = new FileQuery.SubQueriesDTO();
        subQueriesDTO_3.setField("Prefix");
        subQueriesDTO_3.setOperation("Prefix");
        subQueriesDTO_3.setValue("CMB_CMP/");
        subQueries.add(subQueriesDTO_2);
        fileQuery.setSubQueries(subQueries);
        OSSFileAdvancedFilter ossFileAdvancedFilter = new OSSFileAdvancedFilter();
        ossFileAdvancedFilter.getFileList(fileQuery);
    }
}

