/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.invoice.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum TaxpayerTypeEnum {
    GENERAL(1, "\u4e00\u822c\u7eb3\u7a0e\u4eba"),
    SMALL_SCALE(2, "\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba"),
    SMALL_SCALE_TRANSFER(3, "\u8f6c\u767b\u8bb0\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba"),
    TUTORING_PERIOD(4, "\u8f85\u5bfc\u671f\u4e00\u822c\u7eb3\u7a0e\u4eba"),
    NATURAL_PERSON(5, "\u81ea\u7136\u4eba");

    private Integer type;
    private String description;

    private TaxpayerTypeEnum(Integer type, String description) {
        this.description = description;
        this.type = type;
    }

    public static final List<Map> getAllTaxpayerType() {
        return Arrays.stream(TaxpayerTypeEnum.values()).map(o -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", o.getType());
            map.put("description", o.getDescription());
            return map;
        }).collect(Collectors.toList());
    }

    public static final String getDescriptionByTaxpayerType(Integer type) {
        Optional<TaxpayerTypeEnum> optional = Arrays.stream(TaxpayerTypeEnum.values()).filter(o -> o.getType().equals(type)).findAny();
        if (optional.isPresent()) {
            return optional.get().getDescription();
        }
        return "";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}

