/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.gateway.controller;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.datahub.common.api.QueryResult;
import com.thebeastshop.datahub.common.api.Result;
import com.thebeastshop.datahub.common.bgel.ELUtils;
import com.thebeastshop.datahub.common.dto.AggregateNode;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.dto.QueryNode;
import com.thebeastshop.datahub.common.vo.AggregationResult;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import com.thebeastshop.datahub.core.service.BusinessRecordService;
import com.thebeastshop.datahub.dao.support.AggregationSupport;
import com.thebeastshop.datahub.dao.support.QuerySupport;
import com.thebeastshop.datahub.gateway.common.ResultSupport;
import com.thebeastshop.datahub.gateway.util.AddressUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Datahub API Controller")
@RestController
@RequestMapping(value={"/datahub"}, produces={"application/json"})
public class BusinessRecordController {
    private Logger log = LoggerFactory.getLogger(BusinessRecordController.class);
    private BusinessRecordService businessRecordService;

    @Autowired
    public BusinessRecordController(BusinessRecordService businessRecordService) {
        this.businessRecordService = businessRecordService;
    }

    @GetMapping(value={"/{appId}/biznames"})
    public List<String> getBusinessNameList(@PathVariable(value="appId") String appId) {
        return this.businessRecordService.getBusinessNameList(appId);
    }

    @GetMapping(value={"/{appId}/{bizName}/{id}"})
    public Result getById(@PathVariable(value="appId") String appId, @PathVariable(value="bizName") String bizName, @PathVariable(value="id") String id) {
        return ResultSupport.ok(this.businessRecordService.getById(appId, bizName, id));
    }

    @PostMapping(value={"/{appId}/{bizName}/search"})
    public Result<QueryResult<BusinessRecord>> getByCond(HttpServletRequest request, @PathVariable(value="appId") String appId, @PathVariable(value="bizName") String bizName, @RequestBody QueryNode query) {
        String ip = AddressUtil.getIPAddress(request);
        int port = request.getRemotePort();
        this.log.info("[DATAHUB] [{}:{}] \u6761\u4ef6\u67e5\u8be2: appId: {}, bizName: {}, query: {}", new Object[]{ip, port, appId, bizName, JSONObject.toJSONString((Object)query)});
        QuerySupport querySupport = this.getQuerySupport(appId, query);
        QueryResult pageResult = this.businessRecordService.find(appId, bizName, querySupport);
        this.log.info("[DATAHUB] \u67e5\u8be2\u7ed3\u679c\u5171 " + (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getData()) ? pageResult.getData().size() : 0) + " \u6761");
        return ResultSupport.ok(pageResult);
    }

    @PostMapping(value={"/{appId}/{bizName}/aggregate"})
    public Result<List<AggregationResult>> aggregate(HttpServletRequest request, @PathVariable(value="appId") @ApiParam(value="appId") String appId, @PathVariable(value="bizName") @ApiParam(value="bizName") String bizName, @RequestBody @ApiParam(value="aggregate") AggregateNode aggregateNode) {
        String ip = AddressUtil.getIPAddress(request);
        int port = request.getRemotePort();
        this.log.info("[DATAHUB] [{}:{}] \u805a\u5408\u67e5\u8be2: appId: {}, bizName: {}, aggregate: {}", new Object[]{ip, port, appId, bizName, JSONObject.toJSONString((Object)aggregateNode)});
        AggregationSupport aggregationSupport = this.getAggregationSupport(appId, aggregateNode);
        List results = this.businessRecordService.aggregate(appId, bizName, aggregationSupport);
        return ResultSupport.ok(results);
    }

    private QuerySupport getQuerySupport(String appId, QueryNode query) {
        String el = query.getEl();
        CriteriaNode criteriaNode = ELUtils.parseEL((String)el);
        QuerySupport querySupport = new QuerySupport(appId, el, criteriaNode);
        querySupport.setStartRowKey(query.getStartRowKey());
        querySupport.setPage(query.getPage());
        querySupport.setPageSize(query.getPageSize());
        querySupport.setReversed(query.getReversed());
        querySupport.setHasCount(query.getHasCount());
        querySupport.setSort(query.getSort());
        return querySupport;
    }

    private AggregationSupport getAggregationSupport(String appId, AggregateNode aggregateNode) {
        QueryNode query = aggregateNode.getQueryNode();
        QuerySupport querySupport = this.getQuerySupport(appId, query);
        List groupNode = aggregateNode.getGroupNodes();
        AggregationSupport aggregationSupport = new AggregationSupport();
        aggregationSupport.setQuerySupport(querySupport);
        aggregationSupport.setGroupNodes(groupNode);
        return aggregationSupport;
    }
}

