/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.dao.impl;

import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.google.common.collect.Lists;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import com.thebeastshop.bgel.runtime.BgelRange;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.datahub.common.api.QueryResult;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.dto.GroupItemNode;
import com.thebeastshop.datahub.common.dto.GroupNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import com.thebeastshop.datahub.common.enums.DataTypeEnum;
import com.thebeastshop.datahub.common.enums.SortEnum;
import com.thebeastshop.datahub.common.vo.AggregationResult;
import com.thebeastshop.datahub.common.vo.BusinessProperty;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import com.thebeastshop.datahub.common.vo.BusinessStruct;
import com.thebeastshop.datahub.dao.BusinessRecordDao;
import com.thebeastshop.datahub.dao.po.MongoRecordPO;
import com.thebeastshop.datahub.dao.support.AggregationSupport;
import com.thebeastshop.datahub.dao.support.QuerySupport;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.kit.prop.annotation.DynamicPropValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class MongodbBusinessRecordDao
implements BusinessRecordDao {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String COLLECTION_NAME_PREFIX = "hub";
    private static final int OPT_TYPE_WHERE = 0;
    private static final int OPT_TYPE_AND = 1;
    @DynamicPropValue(value="datahub.maxPageSize")
    private long maxPageSize;
    private Set<String> COLLECTION_NAMES = new ConcurrentHashSet();
    @Autowired
    private MongoTemplate mongoTemplate;

    private BusinessRecord convert2Vo(MongoRecordPO po) {
        if (po == null) {
            return null;
        }
        BusinessRecord vo = (BusinessRecord)BeanUtil.buildFrom((Object)po, BusinessRecord.class);
        BusinessStruct businessStruct = new BusinessStruct();
        businessStruct.setName(po.getName());
        Map<String, Object> bizMap = po.getBusiness();
        if (bizMap != null) {
            ArrayList properties = Lists.newArrayListWithExpectedSize((int)bizMap.size());
            for (Map.Entry<String, Object> entry : bizMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                DataTypeEnum dataType = value != null ? DataTypeEnum.getEnumByType(value.getClass()) : null;
                BusinessProperty property = new BusinessProperty(dataType, key, value);
                properties.add(property);
            }
            businessStruct.setProperties((List)properties);
            vo.setBusiness(businessStruct);
        }
        return vo;
    }

    private List<BusinessRecord> convert2VoList(List<MongoRecordPO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return new ArrayList<BusinessRecord>();
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)voList.size());
        for (MongoRecordPO mongo : voList) {
            list.add(this.convert2Vo(mongo));
        }
        return list;
    }

    private MongoRecordPO convert2Po(BusinessRecord vo) {
        if (vo == null) {
            return null;
        }
        MongoRecordPO mongo = (MongoRecordPO)BeanUtil.buildFrom((Object)vo, MongoRecordPO.class);
        BusinessStruct struct = vo.getBusiness();
        if (struct != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            mongo.setName(struct.getName());
            for (BusinessProperty property : struct.getProperties()) {
                map.put(property.getName(), property.getDataType().castValue(property.getValue(), null));
            }
            mongo.setBusiness(map);
        }
        return mongo;
    }

    private List<MongoRecordPO> convert2PoList(List<BusinessRecord> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        }
        ArrayList mongoList = Lists.newArrayListWithExpectedSize((int)voList.size());
        for (BusinessRecord vo : voList) {
            mongoList.add(this.convert2Po(vo));
        }
        return mongoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectionExists(String collectionName) {
        if (this.COLLECTION_NAMES.contains(collectionName)) {
            return true;
        }
        MongodbBusinessRecordDao mongodbBusinessRecordDao = this;
        synchronized (mongodbBusinessRecordDao) {
            if (!this.COLLECTION_NAMES.contains(collectionName)) {
                boolean ret = this.mongoTemplate.collectionExists(collectionName);
                if (ret) {
                    this.COLLECTION_NAMES.add(collectionName);
                }
                return ret;
            }
        }
        return true;
    }

    private String getCollectionName(String appId, String entityName) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.log.error("appId is blank");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)entityName)) {
            this.log.error("entity name is blank");
            return null;
        }
        String tn = "hub." + appId.toLowerCase().trim() + "." + entityName.trim();
        String env = PropConstants.getEnv((Properties)System.getProperties());
        if (!env.equals("prod")) {
            tn = tn + "_" + env.toLowerCase();
        }
        return tn;
    }

    private void collectionExistsOrCreate(String collectionName) {
        MongoCollection document;
        if (!this.collectionExists(collectionName) && (document = this.mongoTemplate.createCollection(collectionName)) != null) {
            this.COLLECTION_NAMES.add(collectionName);
        }
    }

    private Criteria[] getCriteriaCondList(List<CriteriaNode> criteriaNodes) {
        if (CollectionUtils.isEmpty(criteriaNodes)) {
            return null;
        }
        Criteria[] resArray = new Criteria[criteriaNodes.size()];
        for (int i = 0; i < criteriaNodes.size(); ++i) {
            resArray[i] = this.getCriteriaCondition(criteriaNodes.get(i));
        }
        return resArray;
    }

    private Criteria getCriteriaCondition(CriteriaNode criteriaNode) {
        if (criteriaNode == null) {
            return null;
        }
        Criteria criteria = null;
        String key = this.getKey(criteriaNode.getKey());
        Object value = this.getValue(key, criteriaNode.getValue());
        CriteriaOperatorEnum op = criteriaNode.getOp();
        switch (op) {
            case AND: {
                criteria = new Criteria();
                Criteria[] subCriterias = this.getCriteriaCondList(criteriaNode.getChildren());
                criteria = criteria.andOperator(subCriterias);
                break;
            }
            case OR: {
                criteria = new Criteria();
                Criteria[] subCriterias = this.getCriteriaCondList(criteriaNode.getChildren());
                criteria = criteria.orOperator(subCriterias);
                break;
            }
            case NOT: {
                List children = criteriaNode.getChildren();
                if (children == null || children.size() <= 0) break;
                Criteria[] subCriterias = this.getCriteriaCondList(children);
                criteria = criteria.norOperator(subCriterias);
                break;
            }
            case EQ: {
                criteria = Criteria.where((String)key);
                criteria = criteria.is(value);
                break;
            }
            case NE: {
                criteria = Criteria.where((String)key);
                criteria = criteria.ne(value);
                break;
            }
            case LT: {
                criteria = Criteria.where((String)key);
                criteria = criteria.lt(value);
                break;
            }
            case GT: {
                criteria = Criteria.where((String)key);
                criteria = criteria.gt(value);
                break;
            }
            case LE: {
                criteria = Criteria.where((String)key);
                criteria = criteria.lte(value);
                break;
            }
            case GE: {
                criteria = Criteria.where((String)key);
                criteria = criteria.gte(value);
                break;
            }
            case IN: 
            case NOT_IN: {
                if (value instanceof BgelRange) {
                    Comparable from = ((BgelRange)value).getFrom();
                    Comparable to = ((BgelRange)value).getTo();
                    boolean includeFrom = ((BgelRange)value).isIncludeFrom();
                    boolean includeTo = ((BgelRange)value).isIncludeTo();
                    Criteria left = Criteria.where((String)key);
                    left = includeFrom ? left.gte((Object)from) : left.gt((Object)from);
                    Criteria right = Criteria.where((String)key);
                    right = includeTo ? right.lte((Object)to) : right.lt((Object)to);
                    criteria = new Criteria();
                    criteria = criteria.andOperator(new Criteria[]{left, right});
                    break;
                }
                criteria = Criteria.where((String)key);
                if (!(value instanceof Iterable)) {
                    throw new RuntimeException("[DATAHUB] \u8bed\u6cd5\u9519\u8bef\uff1a\u5bf9\u4e8e\u8868\u8fbe\u5f0f'" + String.valueOf(value) + "' \u4e0d\u80fd\u7528\u64cd\u4f5c\u7b26 'in'!");
                }
                if (op == CriteriaOperatorEnum.NOT_IN) {
                    criteria = criteria.not();
                }
                Iterable iterable = (Iterable)value;
                Iterator iter = iterable.iterator();
                LinkedList list = new LinkedList();
                while (iter.hasNext()) {
                    Object val = iter.next();
                    list.add(val);
                }
                criteria = criteria.in(list.toArray());
                break;
            }
            case REGEX_MATCH: 
            case NOT_REGEX_MATCH: {
                criteria = Criteria.where((String)key);
                if (op == CriteriaOperatorEnum.NOT_REGEX_MATCH) {
                    criteria = criteria.not();
                }
                criteria = criteria.regex(String.valueOf(value));
                break;
            }
        }
        return criteria;
    }

    private Query setSort(Query query, QuerySupport querySupport) {
        Map<String, SortEnum> sortMap = querySupport.getSort();
        if (sortMap != null && sortMap.size() > 0) {
            Sort sort = null;
            for (String key : sortMap.keySet()) {
                SortEnum sortEnum = sortMap.get(key);
                Sort.Direction direction = null;
                switch (sortEnum) {
                    case ASC: {
                        direction = Sort.Direction.ASC;
                        break;
                    }
                    case DESC: {
                        direction = Sort.Direction.DESC;
                    }
                }
                if (sort == null) {
                    sort = Sort.by((Sort.Direction)direction, (String[])new String[]{this.getKey(key)});
                    continue;
                }
                sort = sort.and(Sort.by((Sort.Direction)direction, (String[])new String[]{this.getKey(key)}));
            }
            query = query.with(sort);
        }
        return query;
    }

    private boolean isCommonKey(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return key.startsWith("$");
        }
        return false;
    }

    private boolean isPrimaryId(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return key.equals("$id");
    }

    private String getKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        if (this.isPrimaryId(key)) {
            return "_id";
        }
        if (this.isCommonKey(key)) {
            return key.substring(1);
        }
        return "business." + key;
    }

    private Object getValue(String key, Object value) {
        if (this.isPrimaryId(key)) {
            return new ObjectId(value.toString());
        }
        return value;
    }

    @Override
    public List<String> getBusinessNameList(String appId) {
        Set collectionNames = this.mongoTemplate.getCollectionNames();
        String prefix = "hub." + appId.trim().toLowerCase() + ".";
        String env = PropConstants.getEnv((Properties)System.getProperties());
        String postfix = "";
        if (!env.equals("prod")) {
            postfix = "_" + env.toLowerCase();
        }
        int begin = prefix.length();
        LinkedList<String> businessNames = new LinkedList<String>();
        for (String name : collectionNames) {
            if (!name.startsWith(prefix) || !name.endsWith(postfix)) continue;
            int end = name.length() - postfix.length();
            String bizName = name.substring(begin, end);
            businessNames.add(bizName);
        }
        return businessNames;
    }

    @Override
    public void create(BusinessRecord record) {
        MongoRecordPO mongo = this.convert2Po(record);
        String collectionName = this.getCollectionName(mongo.getAppId(), record.getBusiness().getName());
        if (StringUtils.isEmpty((CharSequence)collectionName)) {
            throw new IllegalArgumentException("Mongo collection name is empty");
        }
        this.collectionExistsOrCreate(collectionName);
        mongo.setId(null);
        if (mongo.getCreateTime() == null) {
            mongo.setCreateTime(new Date());
        }
        if (mongo.getUpdateTime() == null) {
            mongo.setUpdateTime(new Date());
        }
        try {
            this.mongoTemplate.insert((Object)mongo, collectionName);
            if (mongo.getBusiness() != null && mongo.getBusiness().containsKey("id")) {
                this.log.info("[DATAHUB] \u6210\u529f\u63d2\u5165 collection: {}, appId: {}, businessId: {}", new Object[]{collectionName, record.getAppId(), mongo.getBusiness().get("id")});
            } else {
                this.log.info("[DATAHUB] \u6210\u529f\u63d2\u5165 collection: {}, appId: {}", (Object)collectionName, (Object)record.getAppId());
            }
        }
        catch (Throwable th) {
            if (mongo.getBusiness() != null && mongo.getBusiness().containsKey("id")) {
                this.log.info("[DATAHUB] \u63d2\u5165\u8bb0\u5f55\u5931\u8d25 collection: {}, appId: {}, businessId: {}", new Object[]{collectionName, record.getAppId(), mongo.getBusiness().get("id")});
            } else {
                this.log.info("[DATAHUB] \u63d2\u5165\u8bb0\u5f55\u5931\u8d25 collection: {}, appId: {}", (Object)collectionName, (Object)record.getAppId());
            }
            throw th;
        }
    }

    @Override
    public long update(BusinessRecord record) {
        if (StringUtils.isBlank((CharSequence)record.getId())) {
            return 0L;
        }
        MongoRecordPO mongo = this.convert2Po(record);
        String collectionName = this.getCollectionName(mongo.getAppId(), record.getBusiness().getName());
        this.collectionExistsOrCreate(collectionName);
        Criteria criteria = Criteria.where((String)"_id").is((Object)record.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("updateTime", (Object)new Date());
        BusinessStruct struct = record.getBusiness();
        if (struct == null) {
            return 0L;
        }
        List properties = struct.getProperties();
        if (CollectionUtils.isEmpty((Collection)properties)) {
            return 0L;
        }
        if (record.getCreator() != null) {
            update.set("creator", (Object)record.getCreator());
        }
        if (record.getReviser() != null) {
            update.set("reviser", (Object)record.getReviser());
        }
        for (BusinessProperty property : properties) {
            update.set(this.getKey(property.getName()), property.getDataType().castValue(property.getValue(), null));
        }
        UpdateResult updateResult = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
        return updateResult.getModifiedCount();
    }

    @Override
    public long batchUpdate(List<BusinessRecord> records) {
        long totalInfluencedCount = 0L;
        for (BusinessRecord record : records) {
            long count = this.update(record);
            totalInfluencedCount += count;
        }
        return totalInfluencedCount;
    }

    @Override
    public BusinessRecord getById(String appId, String entityName, String id) {
        String collectionName = this.getCollectionName(appId, entityName);
        MongoRecordPO mongoRecordPO = (MongoRecordPO)this.mongoTemplate.findById((Object)id, MongoRecordPO.class, collectionName);
        return this.convert2Vo(mongoRecordPO);
    }

    @Override
    public Long count(String appId, String bizName, QuerySupport querySupport) {
        Criteria criteria = Criteria.where((String)"appId").is((Object)appId).and("name").is((Object)bizName);
        CriteriaNode criteriaNode = querySupport.getCriteriaNode();
        criteria = criteria.andOperator(new Criteria[]{this.getCriteriaCondition(criteriaNode)});
        Query query = new Query((CriteriaDefinition)criteria);
        String collectionName = this.getCollectionName(appId, bizName);
        long count = this.mongoTemplate.count(query, collectionName);
        return count;
    }

    public SkipLimit getSkipLimit(QuerySupport querySupport) {
        Long pageSize = querySupport.getPageSize();
        pageSize = pageSize == null ? Long.valueOf(this.maxPageSize) : Long.valueOf(Math.min(pageSize, this.maxPageSize));
        Long page = querySupport.getPage() != null ? querySupport.getPage() : 1L;
        long skip = (page - 1L) * pageSize;
        int limit = pageSize.intValue();
        SkipLimit skipLimit = new SkipLimit();
        skipLimit.page = page;
        skipLimit.pageSize = pageSize;
        skipLimit.skip = skip;
        skipLimit.limit = limit;
        return skipLimit;
    }

    @Override
    public QueryResult<BusinessRecord> find(String appId, String bizName, QuerySupport querySupport) {
        Criteria criteria = Criteria.where((String)"appId").is((Object)appId).and("name").is((Object)bizName);
        CriteriaNode criteriaNode = querySupport.getCriteriaNode();
        if (criteriaNode != null) {
            criteria = criteria.andOperator(new Criteria[]{this.getCriteriaCondition(criteriaNode)});
        }
        SkipLimit skipLimit = this.getSkipLimit(querySupport);
        Query query = new Query((CriteriaDefinition)criteria).skip(skipLimit.skip).limit(skipLimit.limit);
        query = this.setSort(query, querySupport);
        String collectionName = this.getCollectionName(appId, bizName);
        List list = this.mongoTemplate.find(query, MongoRecordPO.class, collectionName);
        QueryResult queryResult = new QueryResult(Long.valueOf(skipLimit.page), Long.valueOf(skipLimit.pageSize));
        List<BusinessRecord> records = this.convert2VoList(list);
        if (CollectionUtils.isNotEmpty(records) && (long)records.size() > skipLimit.pageSize) {
            BusinessRecord lastRecord = records.remove(records.size() - 1);
            queryResult.setHasNextPage(Boolean.valueOf(true));
            queryResult.setNextId(lastRecord.getId());
        }
        queryResult.setData(records);
        Boolean hasCount = querySupport.getHasCount();
        if (hasCount != null && hasCount.booleanValue()) {
            Long count = this.count(appId, bizName, querySupport);
            queryResult.setTotalCount(count.longValue());
        }
        return queryResult;
    }

    @Override
    public QueryResult<BusinessRecord> findDistinct(String appId, String bizName, String fieldName, QuerySupport querySupport) {
        return null;
    }

    @Override
    public List<AggregationResult> aggregate(String appId, String bizName, AggregationSupport aggregationSupport) {
        List<GroupNode> groupNodes = aggregationSupport.getGroupNodes();
        ArrayList<Object> operations = new ArrayList<Object>();
        QuerySupport querySupport = aggregationSupport.getQuerySupport();
        Criteria criteria = Criteria.where((String)"appId").is((Object)appId).and("name").is((Object)bizName);
        CriteriaNode criteriaNode = querySupport.getCriteriaNode();
        if (criteriaNode != null) {
            criteria.andOperator(new Criteria[]{this.getCriteriaCondition(criteriaNode)});
        }
        if (querySupport != null) {
            operations.add(Aggregation.match((Criteria)criteria));
        }
        HashSet<String> aliasSet = new HashSet<String>();
        HashMap<Object, String> keyMap = new HashMap<Object, String>();
        for (GroupNode groupNode : groupNodes) {
            Map itemNodes = groupNode.getItems();
            if (!MapUtils.isNotEmpty((Map)itemNodes)) continue;
            List groupKeys = groupNode.getGroupByKeys();
            String[] keys = new String[groupKeys.size()];
            for (int i = 0; i < groupKeys.size(); ++i) {
                Object key = (String)groupKeys.get(i);
                if (!aliasSet.contains(key)) {
                    String string = this.getKey((String)key);
                    keyMap.put(key, string);
                    key = string;
                }
                keys[i] = key;
            }
            GroupOperation operation = Aggregation.group((String[])keys);
            for (Map.Entry entry : itemNodes.entrySet()) {
                String alias = (String)entry.getKey();
                aliasSet.add(alias);
                GroupItemNode itemNode = (GroupItemNode)entry.getValue();
                String func = itemNode.getFunction();
                Object arg = itemNode.getArg();
                String ref = null;
                if (arg != null) {
                    if (arg instanceof CharSequence) {
                        ref = String.valueOf(arg);
                        if (!aliasSet.contains(ref)) {
                            String realKey = this.getKey(ref);
                            keyMap.put(ref, realKey);
                            ref = realKey;
                        } else if (keyMap.containsKey(ref)) {
                            ref = (String)keyMap.get(ref);
                        }
                    } else {
                        ref = String.valueOf(arg);
                    }
                }
                switch (func) {
                    case "$count": {
                        operation = operation.count().as(alias);
                        break;
                    }
                    case "$sum": {
                        operation = operation.sum(ref).as(alias);
                        break;
                    }
                    case "$avg": {
                        operation = operation.avg(ref).as(alias);
                        break;
                    }
                    case "$max": {
                        operation = operation.max(ref).as(alias);
                        break;
                    }
                    case "$min": {
                        operation = operation.min(ref).as(alias);
                        break;
                    }
                    case "$first": {
                        operation = operation.first(ref).as(alias);
                        break;
                    }
                    case "$last": {
                        operation = operation.last(ref).as(alias);
                    }
                }
            }
            operations.add(operation);
        }
        SkipLimit skipLimit = this.getSkipLimit(querySupport);
        if (skipLimit.skip > 0L) {
            operations.add(Aggregation.skip((long)skipLimit.skip));
        }
        if (skipLimit.limit > 0) {
            operations.add(Aggregation.limit((long)skipLimit.limit));
        }
        String collectionName = this.getCollectionName(appId, bizName);
        AggregationResults results = this.mongoTemplate.aggregate(Aggregation.newAggregation(operations), collectionName, HashMap.class);
        List mappedResults = results.getMappedResults();
        ArrayList<AggregationResult> aggregationResults = new ArrayList<AggregationResult>();
        for (HashMap item : mappedResults) {
            AggregationResult aggregationResult = new AggregationResult();
            for (Object itemKey : item.keySet()) {
                String propName = String.valueOf(itemKey);
                if ("_id".equals(propName)) {
                    Object group = item.get(itemKey);
                    aggregationResult.setGroup(group);
                }
                aggregationResult.getValue().put(propName, item.get(itemKey));
            }
            aggregationResults.add(aggregationResult);
        }
        return aggregationResults;
    }

    @Override
    public void startTransaction() {
    }

    private static class SkipLimit {
        long page;
        long pageSize;
        long skip;
        int limit;

        private SkipLimit() {
        }
    }
}

