/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.commdata.enums;

import java.util.LinkedHashMap;
import java.util.Map;

public enum TmallExchangeOrderStatusEnum {
    PENDING(1, 1, "\u6362\u8d27\u5f85\u5904\u7406"),
    REFUND_INITIATED(14, 40, "\u8bf7\u9000\u6b3e"),
    REJECTED(6, 11, "\u5f85\u4e70\u5bb6\u4fee\u6539"),
    SHIPPED(3, 9, "\u4e70\u5bb6\u5df2\u9000\u8d27\uff0c\u5f85\u6536\u8d27"),
    COMPLETED(5, 5, "\u6362\u8d27\u6210\u529f"),
    CANCELED(4, 6, "\u6362\u8d27\u5173\u95ed"),
    AWAITING_RETURN(2, 12, "\u5f85\u4e70\u5bb6\u9000\u8d27"),
    RETURN_RECEIVED(12, 11, "\u5f85\u53d1\u51fa\u6362\u8d27\u5546\u54c1");

    private final Integer status;
    private final Integer operateType;
    private final String description;

    private TmallExchangeOrderStatusEnum(Integer status, Integer scmStatus, String description) {
        this.status = status;
        this.operateType = scmStatus;
        this.description = description;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getOperateType() {
        return this.operateType;
    }

    public static TmallExchangeOrderStatusEnum fromName(String name) {
        for (TmallExchangeOrderStatusEnum status : TmallExchangeOrderStatusEnum.values()) {
            if (!status.description.equalsIgnoreCase(name)) continue;
            return status;
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684\u72b6\u6001\u540d\u79f0: " + name);
    }

    public static Map<String, Integer> getStatusMapping() {
        LinkedHashMap<String, Integer> mapping = new LinkedHashMap<String, Integer>();
        for (TmallExchangeOrderStatusEnum status : TmallExchangeOrderStatusEnum.values()) {
            mapping.put(status.name(), status.getStatus());
        }
        return mapping;
    }
}

