package com.thebeastshop.cart.model;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 购物车请求商品包对象
 * @author feiLong.gao
 * @date 2019/12/26
 */
public class ScRequestPack extends BaseDO {

    /**
     * 购物车id
     */
    private Long id;

    /**
     * 商品spvId
     */
    private Long spvId;

    /**
     * 商品数量
     */
    private int count = 1;

    /**
     * 商品来源 @CartPackSource ，默认自购
     */
    private CartPackSourceEnum source = CartPackSourceEnum.RAW;

    /**
     * 定制项列表
     */
    private List<ScUserSingleCustomization> customizes;

    /**
     * 綁定值:权益ID
     */
    private String bindValue;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public CartPackSourceEnum getSource() {
        return source;
    }

    public void setSource(CartPackSourceEnum source) {
        this.source = source;
    }

    public List<ScUserSingleCustomization> getCustomizes() {
        return customizes;
    }

    public void setCustomizes(List<ScUserSingleCustomization> customizes) {
        this.customizes = customizes;
    }

    public String getBindValue() {
        return bindValue;
    }

    public void setBindValue(String bindValue) {
        this.bindValue = bindValue;
    }
}
