package com.thebeastshop.cart.model;

import com.thebeastshop.common.BaseDO;

/**
 * 购物车商品卡片
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2020/11/10
 */
public class ScProductCard extends BaseDO {

    private static final long serialVersionUID = 2824218512845885952L;

    /**
     * NONE(0, "不需要"),
     *
     * 	EMPTY(1, "空白"),
     *
     * 	WRITE(2, "代写"),
     *
     * 	VOICE(3, "语音卡");
     * 卡片类型 ： 0-不需要 1-空白 2-代写 3-语音
     */
    private String type;

    /**
     * 卡片抬头信息
     */
    private String to;
    /**
     * 卡片正文
     */
    private String content;

    /**
     * 卡片落款信息
     */
    private String from;

    /**
     * 日期（一个普通展示字段，无业务意义）
     */
    private String date;

    /**
     * 标签（一个普通展示字段，无业务意义）
     */
    private String label;

    /**
     * 数量
     */
    private Integer count = 0;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public String toString() {
        return "ScProductCard{" +
                "type='" + type + '\'' +
                ", to='" + to + '\'' +
                ", content='" + content + '\'' +
                ", from='" + from + '\'' +
                ", date='" + date + '\'' +
                ", label='" + label + '\'' +
                ", count=" + count +
                '}';
    }
}
