package com.thebeastshop.cart.model.gift;

import com.thebeastshop.cart.model.ScProductCard;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 定制卡片，用于商品包
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2020/11/10
 */
public class ScCustomCard extends BaseDO {

    private static final long serialVersionUID = -5804660854134705045L;

    public interface CardStyle {
        String BASE = "BASE";           //普通样式
        String LOVER = "LOVER";         //情人节样式
        String C202201 = "C202201";     //椭圆粉色贴纸
        String C202202 = "C202202";     //方形散香器贴纸（小）
        String C202203 = "C202203";     //方形散香器贴纸（大）
        String C202401 = "C202401";     //24年圣诞定制标签-小号
        String C202402 = "C202402";     //24年圣诞定制标签-大号
    }

    private Boolean canCustom = Boolean.FALSE;

    private Boolean customized = Boolean.FALSE;

    private String cardStyle = CardStyle.BASE;

    private Integer total = 0;

    private Integer blankNum = 0;

    private Integer writeNum = 0;

    private List<ScProductCard> cards;

    public ScCustomCard() {
    }

    public ScCustomCard(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public ScCustomCard(Boolean canCustom, Integer total) {
        this.canCustom = canCustom;
        this.total = total;
    }

    public ScCustomCard(Boolean canCustom, Integer total, String cardStyle) {
        this.canCustom = canCustom;
        this.total = total;
        this.cardStyle = cardStyle;
    }

    public Boolean getCanCustom() {
        return canCustom;
    }

    public void setCanCustom(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public Boolean getCustomized() {
        return customized;
    }

    public void setCustomized(Boolean customized) {
        this.customized = customized;
    }

    public String getCardStyle() {
        return cardStyle;
    }

    public void setCardStyle(String cardStyle) {
        this.cardStyle = cardStyle;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getBlankNum() {
        return blankNum;
    }

    public void setBlankNum(Integer blankNum) {
        this.blankNum = blankNum;
    }

    public Integer getWriteNum() {
        return writeNum;
    }

    public void setWriteNum(Integer writeNum) {
        this.writeNum = writeNum;
    }

    public List<ScProductCard> getCards() {
        return cards;
    }

    public void setCards(List<ScProductCard> cards) {
        this.cards = cards;
    }

    /**
     * 比较redis里存的上次的信息和本次提交的信息，对卡片数据做裁剪（比方上次存了3张，用户在购物车把购买数量改成了2个）
     * @param total
     */
    public void resetTotal(Integer total) {

        if (this.total > total) {
            this.total = total;
        }

        if (writeNum > total) {
            writeNum = total;
            blankNum = 0;
            cards = cards.subList(0, writeNum);
            return;
        }

        if (writeNum.equals(total)) {
            blankNum = 0;
            return;
        }

        if (total - writeNum < blankNum) {
            blankNum = total - writeNum;
        }
    }
}
