package com.thebeastshop.cart.enums;

import com.thebeastshop.common.exception.BaseErrorCode;

/**
 * Created by GFL on 2017/7/6.
 */
public enum CartResultCodeEnum implements BaseErrorCode {

    //系统异常
    SUCCESS("000000","成功"),
    ERROR_RUNTIME("999999","系统异常"),
    ERROR_REMOTE_SERVICE("999888","远程服务异常"),

    //业务异常
    REQUEST_PARAM_WRONG("100101","请求参数错误"),

    // 预览海淘校验异常
    PREVIEW_HAI_TAO_CHECK_ERROR("100201","预览接口必须全是海淘或是普通的"),
    // 预览海淘校验异常
    EDIT_CART_PACK_ERROR("100202","编辑商品包异常"),


    ;





    private String code;
    private String message;


    CartResultCodeEnum(String code, String message){
        this.code = code;
        this.message = message;
    }


    public static CartResultCodeEnum getEnumByCode(String code) {
        CartResultCodeEnum[] arr$ = values();
        int len$ = arr$.length;

        for(int i$ = 0; i$ < len$; ++i$) {
            CartResultCodeEnum e = arr$[i$];
            if (e.getErrorCode().equals(code)) {
                return e;
            }
        }

        return null;
    }


    public String getCode() {
        return code;
    }

    @Override
    public String getPrefix() {
        return "CART";
    }

    @Override
    public String getErrorCode() {
        return this.getPrefix()+this.code;
    }

    public String getMessage() {
        return message;
    }
}
