package com.thebeastshop.cart.enums;

public enum CartPackSourceEnum {

	RAW(Integer.valueOf(0), "自购"),
	GIFT(Integer.valueOf(3), "买赠"),
	ADDIBLE(Integer.valueOf(4), "加价格"),
	BENEFIT(Integer.valueOf(5), "权益商品");

	private Integer code;
	
	private String name;
	
	CartPackSourceEnum(Integer code,String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}
	
	public static CartPackSourceEnum getEnumByCode(Integer code) {
		for (CartPackSourceEnum e : CartPackSourceEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
