/*
 * Decompiled with CFR 0.152.
 */
package com.roncoo.pay.service.notify.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.roncoo.pay.common.core.page.PageBean;
import com.roncoo.pay.common.core.page.PageParam;
import com.roncoo.pay.service.notify.aip.RpNotifyService;
import com.roncoo.pay.service.notify.dao.RpNotifyRecordDao;
import com.roncoo.pay.service.notify.dao.RpNotifyRecordLogDao;
import com.roncoo.pay.service.notify.entity.RpNotifyRecord;
import com.roncoo.pay.service.notify.entity.RpNotifyRecordLog;
import com.roncoo.pay.service.notify.enums.NotifyStatusEnum;
import com.roncoo.pay.service.notify.enums.NotifyTypeEnum;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

@Service(value="rpNotifyService")
public class RpNotifyServiceImpl
implements RpNotifyService {
    @Autowired
    private JmsTemplate notifyJmsTemplate;
    @Autowired
    private RpNotifyRecordDao rpNotifyRecordDao;
    @Autowired
    private RpNotifyRecordLogDao rpNotifyRecordLogDao;

    public void notifySend(String notifyUrl, String merchantOrderNo, String merchantNo) {
        RpNotifyRecord record = new RpNotifyRecord();
        record.setNotifyTimes(Integer.valueOf(0));
        record.setLimitNotifyTimes(Integer.valueOf(5));
        record.setStatus(NotifyStatusEnum.CREATED.name());
        record.setUrl(notifyUrl);
        record.setMerchantOrderNo(merchantOrderNo);
        record.setMerchantNo(merchantNo);
        record.setNotifyType(NotifyTypeEnum.MERCHANT.name());
        Object toJSON = JSONObject.toJSON((Object)record);
        final String str = toJSON.toString();
        this.notifyJmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(str);
            }
        });
    }

    public RpNotifyRecord getNotifyRecordById(String id) {
        return (RpNotifyRecord)this.rpNotifyRecordDao.getById(id);
    }

    public RpNotifyRecord getNotifyByMerchantNoAndMerchantOrderNoAndNotifyType(String merchantNo, String merchantOrderNo, String notifyType) {
        return this.rpNotifyRecordDao.getNotifyByMerchantNoAndMerchantOrderNoAndNotifyType(merchantNo, merchantOrderNo, notifyType);
    }

    public PageBean<RpNotifyRecord> queryNotifyRecordListPage(PageParam pageParam, Map<String, Object> paramMap) {
        return this.rpNotifyRecordDao.listPage(pageParam, paramMap);
    }

    public long createNotifyRecord(RpNotifyRecord rpNotifyRecord) {
        return this.rpNotifyRecordDao.insert(rpNotifyRecord);
    }

    public void updateNotifyRecord(RpNotifyRecord rpNotifyRecord) {
        this.rpNotifyRecordDao.update(rpNotifyRecord);
    }

    public long createNotifyRecordLog(RpNotifyRecordLog rpNotifyRecordLog) {
        return this.rpNotifyRecordLogDao.insert(rpNotifyRecordLog);
    }
}

