/*
 * Decompiled with CFR 0.152.
 */
package com.roncoo.pay.service.account.entity;

import com.roncoo.pay.common.core.entity.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;

public class RpAccount
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1996976092574646493L;
    private String accountNo;
    private BigDecimal balance;
    private BigDecimal unbalance;
    private BigDecimal securityMoney;
    private BigDecimal totalIncome;
    private BigDecimal totalExpend;
    private BigDecimal todayIncome;
    private BigDecimal todayExpend;
    private String accountType;
    private BigDecimal settAmount;
    private String userNo;
    private String userName;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public BigDecimal getAvailableBalance() {
        return this.balance.subtract(this.unbalance);
    }

    public BigDecimal getAvailableSettAmount() {
        BigDecimal subSettAmount = this.settAmount.subtract(this.unbalance);
        if (this.getAvailableBalance().compareTo(subSettAmount) == -1) {
            return this.getAvailableBalance();
        }
        return subSettAmount;
    }

    public boolean availableBalanceIsEnough(BigDecimal amount) {
        return this.getAvailableBalance().compareTo(amount) >= 0;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo == null ? null : accountNo.trim();
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getUnbalance() {
        return this.unbalance;
    }

    public void setUnbalance(BigDecimal unbalance) {
        this.unbalance = unbalance;
    }

    public BigDecimal getSecurityMoney() {
        return this.securityMoney;
    }

    public void setSecurityMoney(BigDecimal securityMoney) {
        this.securityMoney = securityMoney;
    }

    public BigDecimal getTotalIncome() {
        return this.totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    public BigDecimal getTotalExpend() {
        return this.totalExpend;
    }

    public void setTotalExpend(BigDecimal totalExpend) {
        this.totalExpend = totalExpend;
    }

    public BigDecimal getTodayIncome() {
        return this.todayIncome;
    }

    public void setTodayIncome(BigDecimal todayIncome) {
        this.todayIncome = todayIncome;
    }

    public BigDecimal getTodayExpend() {
        return this.todayExpend;
    }

    public void setTodayExpend(BigDecimal todayExpend) {
        this.todayExpend = todayExpend;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType == null ? null : accountType.trim();
    }

    public BigDecimal getSettAmount() {
        return this.settAmount;
    }

    public void setSettAmount(BigDecimal settAmount) {
        this.settAmount = settAmount;
    }

    public String getUserNo() {
        return this.userNo;
    }

    public void setUserNo(String userNo) {
        this.userNo = userNo == null ? null : userNo.trim();
    }
}

