/*
 * Decompiled with CFR 0.152.
 */
package com.freeway.image.combiner.painter;

import com.freeway.image.combiner.element.CombineElement;
import com.freeway.image.combiner.element.ImageElement;
import com.freeway.image.combiner.painter.IPainter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImagePainter
implements IPainter {
    @Override
    public void draw(Graphics2D g, CombineElement element, int canvasWidth) throws Exception {
        ImageElement imageElement = (ImageElement)element;
        BufferedImage image = imageElement.getImage();
        int width = 0;
        int height = 0;
        switch (imageElement.getZoomMode()) {
            case Origin: {
                width = image.getWidth();
                height = image.getHeight();
                break;
            }
            case Width: {
                width = imageElement.getWidth();
                height = image.getHeight() * width / image.getWidth();
                break;
            }
            case Height: {
                height = imageElement.getHeight();
                width = image.getWidth() * height / image.getHeight();
                break;
            }
            case WidthHeight: {
                height = imageElement.getHeight();
                width = imageElement.getWidth();
            }
        }
        if (imageElement.getRoundCorner() != null) {
            image = this.makeRoundCorner(image, width, height, imageElement.getRoundCorner());
        }
        if (imageElement.isCenter()) {
            int centerX = (canvasWidth - width) / 2;
            imageElement.setX(centerX);
        }
        g.setComposite(AlphaComposite.getInstance(10, imageElement.getAlpha()));
        g.drawImage(image, imageElement.getX(), imageElement.getY(), width, height, null);
    }

    private BufferedImage makeRoundCorner(BufferedImage srcImage, int width, int height, int radius) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(0, 0, width, height, radius, radius);
        g.setComposite(AlphaComposite.SrcIn);
        g.drawImage(srcImage, 0, 0, width, height, null);
        g.dispose();
        return image;
    }
}

