/*
 * Decompiled with CFR 0.152.
 */
package com.freeway.image.combiner.element;

import com.freeway.image.combiner.element.CombineElement;
import java.awt.Color;
import java.awt.Font;

public class TextElement
extends CombineElement<TextElement> {
    private String text;
    private Font font;
    private boolean strikeThrough;
    private Color color = new Color(0, 0, 0);
    private boolean autoBreakLine = false;
    private int maxLineWidth = 600;
    private int maxLineCount = 2;
    private int lineHeight = 50;

    public TextElement(String text, Font font, int x, int y) {
        this.text = text;
        this.font = font;
        super.setX(x);
        super.setY(y);
    }

    public TextElement(String text, int fontSize, int x, int y) {
        this.text = text;
        this.font = new Font("\u963f\u91cc\u5df4\u5df4\u666e\u60e0\u4f53", 0, fontSize);
        super.setX(x);
        super.setY(y);
    }

    public TextElement(String text, String fontName, int fontSize, int x, int y) {
        this.text = text;
        this.font = new Font(fontName, 0, fontSize);
        super.setX(x);
        super.setY(y);
    }

    public String getText() {
        return this.text;
    }

    public TextElement setText(String text) {
        this.text = text;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public TextElement setFont(Font font) {
        this.font = font;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public TextElement setColor(Color color) {
        this.color = color;
        return this;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    public TextElement setStrikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
        return this;
    }

    public boolean isAutoBreakLine() {
        return this.autoBreakLine;
    }

    public TextElement setAutoBreakLine(int maxLineWidth, int maxLineCount, int lineHeight) {
        this.autoBreakLine = this.autoBreakLine;
        this.maxLineWidth = maxLineWidth;
        this.maxLineCount = maxLineCount;
        this.lineHeight = lineHeight;
        return this;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public int getMaxLineCount() {
        return this.maxLineCount;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }
}

