/*
 * Decompiled with CFR 0.152.
 */
package com.freeway.image.combiner;

import com.freeway.image.combiner.element.CombineElement;
import com.freeway.image.combiner.element.ImageElement;
import com.freeway.image.combiner.element.TextElement;
import com.freeway.image.combiner.enums.OutputFormat;
import com.freeway.image.combiner.enums.ZoomMode;
import com.freeway.image.combiner.painter.IPainter;
import com.freeway.image.combiner.painter.PainterFactory;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageCombiner {
    private List<CombineElement> combineElements = new ArrayList<CombineElement>();
    private BufferedImage combinedImage;
    private int canvasWidth;
    private int canvasHeight;
    private OutputFormat outputFormat;

    public ImageCombiner(String bgImageUrl, OutputFormat outputFormat) throws Exception {
        ImageElement bgImageElement = new ImageElement(bgImageUrl, 0, 0);
        this.combineElements.add(bgImageElement);
        this.canvasWidth = bgImageElement.getImage().getWidth();
        this.canvasHeight = bgImageElement.getImage().getHeight();
        this.outputFormat = outputFormat;
    }

    public ImageCombiner(BufferedImage bgImage, OutputFormat outputFormat) throws Exception {
        ImageElement bgImageElement = new ImageElement(bgImage, 0, 0);
        this.combineElements.add(bgImageElement);
        this.canvasWidth = bgImage.getWidth();
        this.canvasHeight = bgImage.getHeight();
        this.outputFormat = outputFormat;
    }

    public BufferedImage combine() throws Exception {
        this.combinedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D g = this.combinedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (CombineElement element : this.combineElements) {
            IPainter painter = PainterFactory.createInstance(element);
            painter.draw(g, element, this.canvasWidth);
        }
        g.dispose();
        return this.combinedImage;
    }

    public BufferedImage getCombinedImage() {
        return this.combinedImage;
    }

    public InputStream getCombinedImageStream() throws Exception {
        if (this.combinedImage != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.combinedImage, this.outputFormat.getName(), os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        throw new Exception("\u5c1a\u672a\u6267\u884c\u56fe\u7247\u5408\u6210\uff0c\u65e0\u6cd5\u8f93\u51fa\u6587\u4ef6\u6d41");
    }

    public void save(String filePath) throws Exception {
        if (this.combinedImage == null) {
            throw new Exception("\u5c1a\u672a\u6267\u884c\u56fe\u7247\u5408\u6210\uff0c\u65e0\u6cd5\u4fdd\u5b58\u6587\u4ef6");
        }
        ImageIO.write((RenderedImage)this.combinedImage, this.outputFormat.getName(), new File(filePath));
    }

    public void addElement(CombineElement element) {
        this.combineElements.add(element);
    }

    public ImageElement addImageElement(String imgUrl, int x, int y) {
        ImageElement imageElement = new ImageElement(imgUrl, x, y);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(BufferedImage image, int x, int y) {
        ImageElement imageElement = new ImageElement(image, x, y);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(String imgUrl, int x, int y, int width, int height, ZoomMode zoomMode) {
        ImageElement imageElement = new ImageElement(imgUrl, x, y, width, height, zoomMode);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(BufferedImage image, int x, int y, int width, int height, ZoomMode zoomMode) {
        ImageElement imageElement = new ImageElement(image, x, y, width, height, zoomMode);
        this.combineElements.add(imageElement);
        return imageElement;
    }

    public TextElement addTextElement(String text, Font font, int x, int y) {
        TextElement textElement = new TextElement(text, font, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontSize, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, String fontName, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontName, fontSize, x, y);
        this.combineElements.add(textElement);
        return textElement;
    }
}

