/*
 * Decompiled with CFR 0.152.
 */
package com.fpx.api.utils;

import com.alibaba.fastjson.JSONObject;
import com.fpx.api.constants.AmbientEnum;
import com.fpx.api.model.AffterentParam;
import com.fpx.api.model.ResponseMsg;
import com.fpx.api.utils.HttpClientUtils;
import com.fpx.api.utils.SignUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ApiHttpClientUtils
extends HttpClientUtils {
    public static String apiGet(AffterentParam param, Map<String, Object> paramMap, AmbientEnum ambient) {
        if (!ApiHttpClientUtils.checkParam(param)) {
            return ResponseMsg.fial("\u53c2\u6570\u7f3a\u5931").toString();
        }
        String jsonStr = ApiHttpClientUtils.getBodyJson(paramMap);
        String urlProfiles = ApiHttpClientUtils.getAddress(ambient);
        StringBuilder urlStr = new StringBuilder(urlProfiles);
        urlStr.append("/router/api/service");
        Long timestamp = new Date().getTime();
        String sign = SignUtil.getSingByParam(param, jsonStr, timestamp);
        StringBuilder url = ApiHttpClientUtils.getRequestUrl(param, urlStr, timestamp, sign);
        if (MapUtils.isNotEmpty(paramMap)) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                url.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        String response = null;
        try {
            response = ApiHttpClientUtils.get(url.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static String apiJsongPost(AffterentParam param, Map<String, Object> paramMap, AmbientEnum ambient) {
        if (!ApiHttpClientUtils.checkParam(param)) {
            return ResponseMsg.fial("\u53c2\u6570\u7f3a\u5931").toString();
        }
        String bodyJsonStr = ApiHttpClientUtils.getBodyJson(paramMap);
        String urlProfiles = ApiHttpClientUtils.getAddress(ambient);
        StringBuilder urlStr = new StringBuilder(urlProfiles);
        urlStr.append("/router/api/service");
        Long timestamp = new Date().getTime();
        String sign = SignUtil.getSingByParam(param, bodyJsonStr, timestamp);
        StringBuilder url = ApiHttpClientUtils.getRequestUrl(param, urlStr, timestamp, sign);
        String response = null;
        try {
            response = ApiHttpClientUtils.post(url.toString(), bodyJsonStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private static StringBuilder getRequestUrl(AffterentParam param, StringBuilder urlStr, Long timestamp, String sign) {
        urlStr.append("?method=" + param.getMethod());
        urlStr.append("&app_key=" + param.getAppKey());
        urlStr.append("&v=" + param.getVersion());
        urlStr.append("&timestamp=" + timestamp);
        urlStr.append("&format=" + param.getFormat());
        urlStr.append("&access_token=" + param.getAccessToken());
        urlStr.append("&sign=" + sign);
        urlStr.append("&language=" + param.getLanguage());
        return urlStr;
    }

    private static String getBodyJson(Map<String, Object> paramMap) {
        JSONObject jsonObject = new JSONObject(paramMap);
        return jsonObject.toString();
    }

    private static boolean checkParam(AffterentParam param) {
        return !StringUtils.isBlank((CharSequence)param.getAppKey()) && !StringUtils.isBlank((CharSequence)param.getVersion()) && !StringUtils.isBlank((CharSequence)param.getMethod()) && !StringUtils.isBlank((CharSequence)param.getVersion()) && !StringUtils.isBlank((CharSequence)param.getFormat()) && !StringUtils.isBlank((CharSequence)param.getLanguage()) && !StringUtils.isBlank((CharSequence)param.getAppSecret());
    }
}

