/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datax.domain.response;

import com.thebeastshop.datax.domain.response.DataXResultCode;
import java.io.Serializable;

public class DataXRes<T>
implements Serializable {
    private int code;
    private T data;
    private String message;

    public DataXRes() {
    }

    public DataXRes(int code, T data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public DataXRes(DataXResultCode resultCode, T data, String message) {
        this(resultCode.getCode(), data, message);
    }

    public DataXRes(DataXResultCode resultCode, T data) {
        this(resultCode.getCode(), data, resultCode.getMessage());
    }

    public static <T> DataXRes<T> data(T data) {
        return new DataXRes<T>(DataXResultCode.SUCCESS, data);
    }

    public static <T> DataXRes<T> data(T data, String message) {
        return new DataXRes<T>(DataXResultCode.SUCCESS, data, message);
    }

    public static <T> DataXRes<T> data(DataXResultCode resultCode, T data, String message) {
        return new DataXRes<T>(resultCode, data, message);
    }

    public static <T> DataXRes<T> fail(String msg) {
        return new DataXRes<Object>(DataXResultCode.FAILURE, null, msg);
    }

    public static <T> DataXRes<T> fail(DataXResultCode resultCode, String msg) {
        return new DataXRes<Object>(resultCode, null, msg);
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isSuccess() {
        return this.code == DataXResultCode.SUCCESS.getCode();
    }
}

