/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.works.producers;

import com.beast.clog.agent.Metrics;
import com.beast.clog.agent.works.events.TBaseEvent;
import com.lmax.disruptor.RingBuffer;
import java.util.Date;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.thrift.TBase;

public class TBaseEventProducer {
    private final RingBuffer<TBaseEvent> ringBuffer;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();

    public TBaseEventProducer(RingBuffer<TBaseEvent> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TBase base) {
        long start = new Date().getTime();
        try {
            long sequence;
            this.lock.lock();
            try {
                while (!this.ringBuffer.hasAvailableCapacity(1)) {
                    long now = new Date().getTime();
                    if (now - start > 100L) {
                        return;
                    }
                    this.notFull.awaitNanos(10L);
                }
                sequence = this.ringBuffer.next();
            }
            finally {
                this.notFull.signal();
                this.lock.unlock();
            }
            try {
                TBaseEvent event = (TBaseEvent)this.ringBuffer.get(sequence);
                event.setBase(base);
            }
            finally {
                this.ringBuffer.publish(sequence);
                Metrics.instance().getPutQueueCounter().incrementAndGet();
            }
            return;
        }
        catch (InterruptedException e) {
            return;
        }
    }
}

