/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.trace.impl;

import com.beast.clog.agent.AgentManager;
import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.trace.ITraceSender;
import com.beast.clog.agent.trace.impl.CommonTracer;
import com.beast.clog.agent.utils.LogEventUtil;
import com.beast.clog.agent.works.producers.TBaseEventProducer;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.LogLevel;
import com.beast.clog.models.thrift.LogType;
import com.beast.clog.models.thrift.Span;
import java.util.ArrayList;
import org.apache.thrift.TBase;

public class CLoggingTracer
extends CommonTracer {
    public CLoggingTracer(String name) {
        super(name);
        this.setSender(new CLoggingTraceSender());
    }

    static class CLoggingTraceSender
    implements ITraceSender {
        CLoggingTraceSender() {
        }

        @Override
        public void send(Span span) {
            if (!LogConfig.getInstance().isInited()) {
                return;
            }
            TBaseEventProducer messageProducer = AgentManager.getInstance().getMessageProducer();
            boolean traceEnabled = LogConfig.getInstance().isTraceEnabled();
            if (traceEnabled && messageProducer != null) {
                this.filterLogEventByLevel(span);
                for (LogEvent logEvent : span.getLogEvents()) {
                    LogEventUtil.truncateLogSize(logEvent, LogConfig.getInstance().getMaxMessageSize());
                }
                messageProducer.put((TBase)span);
            } else {
                for (LogEvent logEvent : span.getLogEvents()) {
                    if (logEvent.getLogType() != LogType.APP) continue;
                    LogEventUtil.truncateLogSize(logEvent, LogConfig.getInstance().getMaxMessageSize());
                    logEvent.setTraceId(0L);
                    messageProducer.put((TBase)logEvent);
                }
            }
        }

        @Override
        public void send(LogEvent logEvent) {
            if (!LogConfig.getInstance().isInited()) {
                return;
            }
            TBaseEventProducer messageProducer = AgentManager.getInstance().getMessageProducer();
            boolean traceEnabled = LogConfig.getInstance().isTraceEnabled();
            if (logEvent.getLogType() != LogType.APP) {
                if (traceEnabled) {
                    if (!this.isLogLevelEnabled(logEvent.getLogLevel())) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if (!this.isLogLevelEnabled(logEvent.getLogLevel())) {
                return;
            }
            LogEventUtil.truncateLogSize(logEvent, LogConfig.getInstance().getMaxMessageSize());
            messageProducer.put((TBase)logEvent);
        }

        private void filterLogEventByLevel(Span span) {
            if (span.getLogEvents() != null && span.getLogEvents().size() > 0) {
                ArrayList<LogEvent> tobeRemovedList = new ArrayList<LogEvent>();
                for (LogEvent logEvent : span.getLogEvents()) {
                    if (logEvent.getLogType() == LogType.APP || this.isLogLevelEnabled(logEvent.getLogLevel())) continue;
                    tobeRemovedList.add(logEvent);
                }
                if (tobeRemovedList.size() > 0) {
                    span.getLogEvents().removeAll(tobeRemovedList);
                }
            }
        }

        private boolean isLogLevelEnabled(LogLevel level) {
            return level.getValue() >= LogConfig.getInstance().getLevel().getValue();
        }
    }
}

