/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.log.impl;

import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.log.ILog;
import com.beast.clog.agent.log.ILogSender;
import com.beast.clog.common.utils.IdentityUtil;
import com.beast.clog.common.utils.Strings;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.LogLevel;
import com.beast.clog.models.thrift.LogType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLoggingLogger
implements ILog {
    private static final Logger logger = LoggerFactory.getLogger(CLoggingLogger.class);
    private String logName = "";
    private ILogSender logSender;

    public CLoggingLogger(String logName, ILogSender sender) {
        this.logName = Strings.isNullOrEmpty((String)logName) ? "defaultLogName" : logName;
        this.logSender = sender;
    }

    private void writeLog(LogLevel logLevel, String title, String message, Throwable throwable, Map<String, String> attrs) {
        if (LogConfig.getInstance().getEnvironmentGroup() == "local" && !LogConfig.getInstance().isAppLocalLogEnabled()) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(message, throwable);
                    break;
                }
                case INFO: {
                    logger.info(message, throwable);
                    break;
                }
                case WARN: {
                    logger.warn(message, throwable);
                    break;
                }
                default: {
                    logger.error(message, throwable);
                    break;
                }
            }
        } else {
            LogEvent logEvent = new LogEvent();
            logEvent.setId(IdentityUtil.getUniqueID());
            logEvent.setTitle(title);
            logEvent.setLogLevel(logLevel);
            logEvent.setLogType(LogType.APP);
            logEvent.setSource(this.logName);
            logEvent.setThreadId(Thread.currentThread().getId());
            logEvent.setCreatedTime(System.currentTimeMillis());
            logEvent.setAttributes(attrs);
            if (Strings.isNullOrEmpty((String)title)) {
                logEvent.setTitle("NA");
            }
            if (message != null) {
                logEvent.setMessage(message);
            }
            if (throwable != null) {
                if (logEvent.getTitle().equals("NA")) {
                    logEvent.setTitle(throwable.getMessage());
                }
                logEvent.setMessage(Strings.toString((Throwable)throwable));
            }
            if (logEvent.getMessage() == null) {
                logEvent.setMessage("");
            }
            if (this.logSender != null) {
                this.logSender.send(logEvent);
            }
        }
    }

    @Override
    public void debug(String title, String message) {
        this.writeLog(LogLevel.DEBUG, title, message, null, null);
    }

    @Override
    public void debug(String title, Throwable throwable) {
        this.writeLog(LogLevel.DEBUG, title, null, throwable, null);
    }

    @Override
    public void debug(String title, String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.DEBUG, title, message, null, attrs);
    }

    @Override
    public void debug(String title, Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.DEBUG, title, null, throwable, attrs);
    }

    @Override
    public void debug(String message) {
        this.writeLog(LogLevel.DEBUG, null, message, null, null);
    }

    @Override
    public void debug(Throwable throwable) {
        this.writeLog(LogLevel.DEBUG, null, null, throwable, null);
    }

    @Override
    public void debug(String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.DEBUG, null, message, null, attrs);
    }

    @Override
    public void debug(Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.DEBUG, null, null, throwable, attrs);
    }

    @Override
    public void error(String title, String message) {
        this.writeLog(LogLevel.ERROR, title, message, null, null);
    }

    @Override
    public void error(String title, Throwable throwable) {
        this.writeLog(LogLevel.ERROR, title, null, throwable, null);
    }

    @Override
    public void error(String title, String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.ERROR, title, message, null, attrs);
    }

    @Override
    public void error(String title, Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.ERROR, title, null, throwable, attrs);
    }

    @Override
    public void error(String message) {
        this.writeLog(LogLevel.ERROR, null, message, null, null);
    }

    @Override
    public void error(Throwable throwable) {
        this.writeLog(LogLevel.ERROR, null, null, throwable, null);
    }

    @Override
    public void error(String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.ERROR, null, message, null, attrs);
    }

    @Override
    public void error(Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.ERROR, null, null, throwable, attrs);
    }

    @Override
    public void fatal(String title, String message) {
        this.writeLog(LogLevel.FATAL, title, message, null, null);
    }

    @Override
    public void fatal(String title, Throwable throwable) {
        this.writeLog(LogLevel.FATAL, title, null, throwable, null);
    }

    @Override
    public void fatal(String title, String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.FATAL, title, message, null, attrs);
    }

    @Override
    public void fatal(String title, Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.FATAL, null, null, throwable, attrs);
    }

    @Override
    public void fatal(String message) {
        this.writeLog(LogLevel.FATAL, null, message, null, null);
    }

    @Override
    public void fatal(Throwable throwable) {
        this.writeLog(LogLevel.FATAL, null, null, throwable, null);
    }

    @Override
    public void fatal(String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.FATAL, null, message, null, attrs);
    }

    @Override
    public void fatal(Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.FATAL, null, null, throwable, attrs);
    }

    @Override
    public void info(String title, String message) {
        this.writeLog(LogLevel.INFO, title, message, null, null);
    }

    @Override
    public void info(String title, Throwable throwable) {
        this.writeLog(LogLevel.INFO, title, null, throwable, null);
    }

    @Override
    public void info(String title, String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.INFO, title, message, null, attrs);
    }

    @Override
    public void info(String title, Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.INFO, null, null, throwable, attrs);
    }

    @Override
    public void info(String message) {
        this.writeLog(LogLevel.INFO, null, message, null, null);
    }

    @Override
    public void info(Throwable throwable) {
        this.writeLog(LogLevel.INFO, null, null, throwable, null);
    }

    @Override
    public void info(String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.INFO, null, message, null, attrs);
    }

    @Override
    public void info(Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.INFO, null, null, throwable, attrs);
    }

    @Override
    public void warn(String title, String message) {
        this.writeLog(LogLevel.WARN, title, message, null, null);
    }

    @Override
    public void warn(String title, Throwable throwable) {
        this.writeLog(LogLevel.WARN, title, null, throwable, null);
    }

    @Override
    public void warn(String title, String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.WARN, title, message, null, attrs);
    }

    @Override
    public void warn(String title, Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.WARN, title, null, throwable, attrs);
    }

    @Override
    public void warn(String message) {
        this.writeLog(LogLevel.WARN, null, message, null, null);
    }

    @Override
    public void warn(Throwable throwable) {
        this.writeLog(LogLevel.WARN, null, null, throwable, null);
    }

    @Override
    public void warn(String message, Map<String, String> attrs) {
        this.writeLog(LogLevel.WARN, null, message, null, attrs);
    }

    @Override
    public void warn(Throwable throwable, Map<String, String> attrs) {
        this.writeLog(LogLevel.WARN, null, null, throwable, attrs);
    }
}

