/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent;

import com.beast.clog.common.utils.Strings;
import java.util.HashMap;
import java.util.Map;

public class TagBuilder {
    private Map<String, String> tags = new HashMap<String, String>();

    private TagBuilder() {
    }

    public static TagBuilder create() {
        return new TagBuilder();
    }

    public TagBuilder append(String key, Object value) {
        if (!Strings.isNullOrEmpty((String)key)) {
            this.tags.put(key, value == null ? "NA" : value.toString());
        }
        return this;
    }

    public TagBuilder append(Map<String, String> attrs) {
        if (attrs != null) {
            for (String key : attrs.keySet()) {
                this.tags.put(key, attrs.get(key));
            }
        }
        return this;
    }

    public TagBuilder append(String tagStr) {
        if (!Strings.isNullOrEmpty((String)tagStr)) {
            String[] tgs;
            for (String tg : tgs = tagStr.split(",")) {
                String[] kvs = tg.split("=");
                if (kvs.length != 2) continue;
                this.tags.put(kvs[0], kvs[1]);
            }
        }
        return this;
    }

    public Map<String, String> build() {
        return this.tags;
    }
}

