/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.works.producers;

import com.beast.clog.agent.Metrics;
import com.beast.clog.agent.works.events.TBaseEvent;
import com.lmax.disruptor.RingBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBaseEventProducer {
    private Logger logger = LoggerFactory.getLogger(TBaseEventProducer.class);
    private final RingBuffer<TBaseEvent> ringBuffer;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public TBaseEventProducer(RingBuffer<TBaseEvent> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TBase base) {
        int count = 0;
        this.lock.lock();
        try {
            while (!this.ringBuffer.hasAvailableCapacity(1)) {
                if (count > 200) {
                    throw new RuntimeException("CLog RingBuffer is Exhausted!");
                }
                if (count > 50) {
                    this.condition.wait(1L);
                } else {
                    this.condition.await();
                }
                ++count;
            }
            long sequence = this.ringBuffer.next();
            try {
                TBaseEvent event = (TBaseEvent)this.ringBuffer.get(sequence);
                event.setBase(base);
            }
            finally {
                this.ringBuffer.publish(sequence);
                Metrics.instance().getPutQueueCounter().incrementAndGet();
                this.condition.signalAll();
            }
            return;
        }
        catch (InterruptedException e) {
            this.logger.error("CLog Thread Error[" + Thread.currentThread().getName() + "]: " + e.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }
}

