/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring;

import com.beast.clog.agent.spring.annotations.Trace;
import com.beast.clog.models.thrift.LogLevel;
import com.beast.clog.models.thrift.LogType;
import com.beast.clog.models.thrift.SpanType;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;

public class TraceContext {
    private static Map<String, TraceContext> cache = new HashMap<String, TraceContext>();
    private String traceName;
    private String spanName;
    private String serviceName;
    private LogType logType;
    private SpanType spanType;
    private LogLevel level;

    private TraceContext() {
    }

    public static TraceContext create(Invocation invocation) {
        if (invocation == null || invocation.getMethod() == null) {
            return new TraceContext();
        }
        TraceContext context = null;
        try {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            String sqlId = mappedStatement.getId();
            if (cache.containsKey(sqlId)) {
                context = cache.get(sqlId);
            } else {
                context = new TraceContext();
                context.setTraceName(sqlId);
                context.setServiceName(sqlId);
                context.setSpanName(invocation.getMethod().getName());
                context.setSpanType(SpanType.SQL);
                context.setLogType(LogType.SQL);
                context.setLevel(LogLevel.INFO);
                cache.put(sqlId, context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return context;
    }

    public static TraceContext create(MethodInvocation methodInvocation) {
        if (methodInvocation == null || methodInvocation.getMethod() == null) {
            return new TraceContext();
        }
        TraceContext context = null;
        try {
            if (cache.containsKey(methodInvocation.toString())) {
                context = cache.get(methodInvocation.toString());
            } else {
                context = new TraceContext();
                context.setTraceName(methodInvocation.getThis().getClass().getName());
                context.setServiceName(methodInvocation.getThis().getClass().getName());
                context.setSpanName(methodInvocation.getMethod().getName());
                Trace traceAnnotation = methodInvocation.getMethod().getAnnotation(Trace.class);
                if (traceAnnotation == null) {
                    traceAnnotation = methodInvocation.getThis().getClass().getAnnotation(Trace.class);
                }
                if (traceAnnotation != null) {
                    if (!traceAnnotation.traceName().isEmpty()) {
                        context.setTraceName(traceAnnotation.traceName());
                    }
                    context.setLogType(traceAnnotation.type());
                    context.setLevel(traceAnnotation.level());
                }
                if (context.getSpanType() == null) {
                    if (context.getLogType() == LogType.WEB_SERVICE) {
                        context.setSpanType(SpanType.WEB_SERVICE);
                    } else if (context.getLogType() == LogType.MEMCACHED) {
                        context.setSpanType(SpanType.MEMCACHED);
                    } else if (context.getLogType() == LogType.SQL) {
                        context.setSpanType(SpanType.SQL);
                    } else if (context.getLogType() == LogType.URL) {
                        context.setSpanType(SpanType.SQL);
                    } else {
                        context.setSpanType(SpanType.OTHER);
                    }
                }
                cache.put(methodInvocation.toString(), context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return context;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public void setSpanName(String spanName) {
        this.spanName = spanName;
    }

    public String getTraceName() {
        return this.traceName;
    }

    public LogType getLogType() {
        return this.logType;
    }

    public void setLogType(LogType logType) {
        this.logType = logType;
    }

    public void setTraceName(String traceName) {
        this.traceName = traceName;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel level) {
        this.level = level;
    }

    public SpanType getSpanType() {
        return this.spanType;
    }

    public void setSpanType(SpanType spanType) {
        this.spanType = spanType;
    }
}

