/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.metircs.impl;

import com.beast.clog.agent.TagBuilder;
import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.log.ILog;
import com.beast.clog.agent.log.LogManager;
import com.beast.clog.agent.metircs.IMetrics;
import com.beast.clog.agent.metircs.IMetricsSender;
import com.beast.clog.models.thrift.MetricEvent;
import com.beast.clog.models.thrift.MetricValueType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CLoggingMetrics
implements IMetrics {
    private static ILog logger = LogManager.getLogger(CLoggingMetrics.class);
    private IMetricsSender metricsSender;
    private static final int MAX_TAG_COUNT = 6;

    public CLoggingMetrics(IMetricsSender metricsSender) {
        this.metricsSender = metricsSender;
    }

    private void recordMetrics(String name, String value, MetricValueType valueType, Map<String, String> tags, Long createTime) {
        if ("local".equals(LogConfig.getInstance().getEnvironmentGroup()) && !LogConfig.getInstance().isAppLocalLogEnabled()) {
            return;
        }
        MetricEvent metricEvent = new MetricEvent();
        metricEvent.setName(name);
        metricEvent.setValue(value.toString());
        metricEvent.setValueType(valueType);
        tags = this.removeMoreTags(tags);
        tags = this.addFixedTags(tags);
        metricEvent.setTags(tags);
        if (createTime == null) {
            metricEvent.setCreatedTime(System.currentTimeMillis());
        } else {
            metricEvent.setCreatedTime(createTime.longValue());
        }
        if (this.metricsSender != null) {
            this.metricsSender.send(metricEvent);
        }
    }

    private Map<String, String> removeMoreTags(Map<String, String> tags) {
        if (tags != null && tags.size() > 6) {
            Iterator<String> iter = tags.keySet().iterator();
            int count = 1;
            while (iter.hasNext()) {
                iter.next();
                if (count > 6) {
                    iter.remove();
                }
                ++count;
            }
        }
        return tags;
    }

    private Map<String, String> addFixedTags(Map<String, String> tags) {
        if (tags == null) {
            tags = new HashMap<String, String>();
        }
        tags.put("fixed-env", LogConfig.getInstance().getEnvironmentGroup());
        tags.put("fixed-cluster", LogConfig.getInstance().getEnvironment());
        return tags;
    }

    private void writerLog(String name) {
        logger.error("Metrics\u503c\u4e0d\u5f97\u4e3anull", "name=" + name + ", value=null", TagBuilder.create().append("metricName", name).build());
    }

    @Override
    public void record(String name, Integer value) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, null, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Long value) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, null, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Float value) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, null, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Double value) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, null, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, BigDecimal value) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, null, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Integer value, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, null, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Long value, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, null, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Float value, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, null, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Double value, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, null, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, BigDecimal value, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, null, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Integer value, Map<String, String> tags) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, tags, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Long value, Map<String, String> tags) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, tags, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Float value, Map<String, String> tags) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, tags, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Double value, Map<String, String> tags) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, tags, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, BigDecimal value, Map<String, String> tags) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, tags, null);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Integer value, Map<String, String> tags, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, tags, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Long value, Map<String, String> tags, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_LONG, tags, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Float value, Map<String, String> tags, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, tags, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, Double value, Map<String, String> tags, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, tags, time);
        } else {
            this.writerLog(name);
        }
    }

    @Override
    public void record(String name, BigDecimal value, Map<String, String> tags, Long time) {
        if (value != null) {
            this.recordMetrics(name, value.toString(), MetricValueType.TYPE_FLOAT, tags, time);
        } else {
            this.writerLog(name);
        }
    }
}

