/**
 *    Copyright (C) 2012 ZeroTurnaround LLC <support@zeroturnaround.com>
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class FileSource implements ZipEntrySource {

  private final String path;
  private final File file;
  
  public FileSource(String path, File file) {
    this.path = path;
    this.file = file;
  }
  
  public String getPath() {
    return path;
  }
  
  public ZipEntry getEntry() {
    ZipEntry entry = new ZipEntry(path);
    if (!file.isDirectory()) {
      entry.setSize(file.length());
    }
    entry.setTime(file.lastModified());
    return entry;
  }

  public InputStream getInputStream() throws IOException {
    if (file.isDirectory()) {
      return null;
    }
    else {
      return new BufferedInputStream(new FileInputStream(file));
    }
  }
  
  public String toString() {
    return "FileSource[" + path + ", " + file + "]";
  }

}
