/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;

public class StartProcessInstanceCmd<T>
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected String businessKey;
    protected String tenantId;
    protected String overrideDefinitionTenantId;
    protected String predefinedProcessInstanceId;
    protected String processInstanceName;
    protected String callbackId;
    protected String callbackType;
    protected Map<String, Object> startFormVariables;
    protected String outcome;
    protected boolean fallbackToDefaultTenant;
    protected ProcessInstanceHelper processInstanceHelper;

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
    }

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables, String tenantId) {
        this(processDefinitionKey, processDefinitionId, businessKey, variables);
        this.tenantId = tenantId;
    }

    public StartProcessInstanceCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        this(processInstanceBuilder.getProcessDefinitionKey(), processInstanceBuilder.getProcessDefinitionId(), processInstanceBuilder.getBusinessKey(), processInstanceBuilder.getVariables(), processInstanceBuilder.getTenantId());
        this.processInstanceName = processInstanceBuilder.getProcessInstanceName();
        this.overrideDefinitionTenantId = processInstanceBuilder.getOverrideDefinitionTenantId();
        this.predefinedProcessInstanceId = processInstanceBuilder.getPredefinedProcessInstanceId();
        this.transientVariables = processInstanceBuilder.getTransientVariables();
        this.callbackId = processInstanceBuilder.getCallbackId();
        this.callbackType = processInstanceBuilder.getCallbackType();
        this.startFormVariables = processInstanceBuilder.getStartFormVariables();
        this.outcome = processInstanceBuilder.getOutcome();
        this.fallbackToDefaultTenant = processInstanceBuilder.isFallbackToDefaultTenant();
    }

    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        this.processInstanceHelper = processEngineConfiguration.getProcessInstanceHelper();
        ProcessDefinition processDefinition = this.getProcessDefinition(processEngineConfiguration);
        ProcessInstance processInstance = null;
        processInstance = this.hasStartFormData() ? this.handleProcessInstanceWithForm(commandContext, processDefinition, processEngineConfiguration) : this.startProcessInstance(processDefinition);
        return processInstance;
    }

    protected ProcessInstance handleProcessInstanceWithForm(CommandContext commandContext, ProcessDefinition processDefinition, ProcessEngineConfigurationImpl processEngineConfiguration) {
        FormInfo formInfo = null;
        Map formVariables = null;
        if (this.hasStartFormData()) {
            StartEvent startEvent;
            FormService formService = CommandContextUtil.getFormService(commandContext);
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId());
            Process process = bpmnModel.getProcessById(processDefinition.getKey());
            FlowElement startElement = process.getInitialFlowElement();
            if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey())) {
                FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService(commandContext);
                formInfo = this.tenantId == null || "".equals(this.tenantId) ? formRepositoryService.getFormModelByKey(startEvent.getFormKey()) : formRepositoryService.getFormModelByKey(startEvent.getFormKey(), this.tenantId, processEngineConfiguration.isFallbackToDefaultTenant());
                if (formInfo != null && (formVariables = formService.getVariablesFromFormSubmission(formInfo, this.startFormVariables, this.outcome)) != null) {
                    if (this.variables == null) {
                        this.variables = new HashMap<String, Object>();
                    }
                    this.variables.putAll(formVariables);
                }
            }
        }
        ProcessInstance processInstance = this.startProcessInstance(processDefinition);
        if (formInfo != null) {
            FormService formService = CommandContextUtil.getFormService(commandContext);
            formService.createFormInstance(formVariables, formInfo, null, processInstance.getId(), processInstance.getProcessDefinitionId(), processInstance.getTenantId());
            FormFieldHandler formFieldHandler = processEngineConfiguration.getFormFieldHandler();
            formFieldHandler.handleFormFieldsOnSubmit(formInfo, null, processInstance.getId(), null, null, this.variables, processInstance.getTenantId());
        }
        return processInstance;
    }

    protected ProcessInstance startProcessInstance(ProcessDefinition processDefinition) {
        return this.processInstanceHelper.createProcessInstance(processDefinition, this.businessKey, this.processInstanceName, this.overrideDefinitionTenantId, this.predefinedProcessInstanceId, this.variables, this.transientVariables, this.callbackId, this.callbackType, true);
    }

    protected boolean hasStartFormData() {
        return this.startFormVariables != null || this.outcome != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ProcessDefinition getProcessDefinition(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ProcessDefinitionEntityManager processDefinitionEntityManager = processEngineConfiguration.getProcessDefinitionEntityManager();
        ProcessDefinition processDefinition = null;
        if (this.processDefinitionId != null) {
            processDefinition = (ProcessDefinition)processDefinitionEntityManager.findById(this.processDefinitionId);
            if (processDefinition != null) return processDefinition;
            throw new FlowableObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        if (this.processDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId))) {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKey(this.processDefinitionKey);
            if (processDefinition != null) return processDefinition;
            throw new FlowableObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'", ProcessDefinition.class);
        }
        if (this.processDefinitionKey == null || this.tenantId == null || "".equals(this.tenantId)) throw new FlowableIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, this.tenantId);
        if (processDefinition != null) return processDefinition;
        if (!this.fallbackToDefaultTenant && !processEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("Process definition with key '" + this.processDefinitionKey + "' and tenantId '" + this.tenantId + "' was not found", ProcessDefinition.class);
        if (StringUtils.isNotEmpty((CharSequence)processEngineConfiguration.getDefaultTenantValue())) {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, processEngineConfiguration.getDefaultTenantValue());
            if (processDefinition != null) {
                this.overrideDefinitionTenantId = this.tenantId;
            }
        } else {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKey(this.processDefinitionKey);
        }
        if (processDefinition != null) return processDefinition;
        throw new FlowableObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'. Fallback to default tenant was also applied.", ProcessDefinition.class);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

