/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.flowable.engine.impl.delegate.InactiveActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ExecutionGraphUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InclusiveGatewayActivityBehavior
extends GatewayActivityBehavior
implements InactiveActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InclusiveGatewayActivityBehavior.class.getName());

    @Override
    public void execute(DelegateExecution execution) {
        execution.inactivate();
        this.executeInclusiveGatewayLogic((ExecutionEntity)execution);
    }

    @Override
    public void executeInactive(ExecutionEntity executionEntity) {
        this.executeInclusiveGatewayLogic(executionEntity);
    }

    protected void executeInclusiveGatewayLogic(ExecutionEntity execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        this.lockFirstParentScope(execution);
        List<ExecutionEntity> allExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        Iterator executionIterator = allExecutions.iterator();
        boolean oneExecutionCanReachGatewayInstance = false;
        while (!oneExecutionCanReachGatewayInstance && executionIterator.hasNext()) {
            ExecutionEntity executionEntity = (ExecutionEntity)executionIterator.next();
            if (!executionEntity.getActivityId().equals(execution.getCurrentActivityId())) {
                if (!ExecutionGraphUtil.isReachable(execution.getProcessDefinitionId(), executionEntity.getActivityId(), execution.getCurrentActivityId()) || !executionEntity.getParentId().equals(execution.getParentId())) continue;
                oneExecutionCanReachGatewayInstance = true;
                break;
            }
            if (!executionEntity.getId().equals(execution.getId()) || !executionEntity.isActive()) continue;
            oneExecutionCanReachGatewayInstance = true;
            break;
        }
        CommandContextUtil.getActivityInstanceEntityManager(commandContext).recordActivityEnd(execution, null);
        if (!oneExecutionCanReachGatewayInstance) {
            LOGGER.debug("Inclusive gateway cannot be reached by any execution and is activated");
            Collection<ExecutionEntity> executionsInGateway = executionEntityManager.findInactiveExecutionsByActivityIdAndProcessInstanceId(execution.getCurrentActivityId(), execution.getProcessInstanceId());
            for (ExecutionEntity executionEntityInGateway : executionsInGateway) {
                if (executionEntityInGateway.getId().equals(execution.getId()) || !executionEntityInGateway.getParentId().equals(execution.getParentId())) continue;
                CommandContextUtil.getActivityInstanceEntityManager(commandContext).recordActivityEnd(executionEntityInGateway, null);
                executionEntityManager.deleteExecutionAndRelatedData(executionEntityInGateway, null, false);
            }
            CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsOperation(execution, true);
        }
    }
}

