/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.repository.EngineResource;
import org.flowable.engine.common.impl.persistence.entity.AbstractEntityNoRevision;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class DeploymentEntityImpl
extends AbstractEntityNoRevision
implements DeploymentEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String category;
    protected String key;
    protected String tenantId = "";
    protected Map<String, EngineResource> resources;
    protected Date deploymentTime;
    protected boolean isNew;
    protected String derivedFrom;
    protected String derivedFromRoot;
    protected String engineVersion;
    protected Map<Class<?>, List<Object>> deployedArtifacts;

    @Override
    public void addResource(ResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, EngineResource>();
        }
        this.resources.put(resource.getName(), resource);
    }

    public Map<String, EngineResource> getResources() {
        if (this.resources == null && this.id != null) {
            List<ResourceEntity> resourcesList = CommandContextUtil.getResourceEntityManager().findResourcesByDeploymentId(this.id);
            this.resources = new HashMap<String, EngineResource>();
            for (ResourceEntity resource : resourcesList) {
                this.resources.put(resource.getName(), resource);
            }
        }
        return this.resources;
    }

    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("category", this.category);
        persistentState.put("key", this.key);
        persistentState.put("tenantId", this.tenantId);
        return persistentState;
    }

    @Override
    public void addDeployedArtifact(Object deployedArtifact) {
        Class<?> clazz;
        List<Object> artifacts;
        if (this.deployedArtifacts == null) {
            this.deployedArtifacts = new HashMap();
        }
        if ((artifacts = this.deployedArtifacts.get(clazz = deployedArtifact.getClass())) == null) {
            artifacts = new ArrayList<Object>();
            this.deployedArtifacts.put(clazz, artifacts);
        }
        artifacts.add(deployedArtifact);
    }

    @Override
    public <T> List<T> getDeployedArtifacts(Class<T> clazz) {
        for (Class<?> deployedArtifactsClass : this.deployedArtifacts.keySet()) {
            if (!clazz.isAssignableFrom(deployedArtifactsClass)) continue;
            return this.deployedArtifacts.get(deployedArtifactsClass);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public void setResources(Map<String, EngineResource> resources) {
        this.resources = resources;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    @Override
    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    @Override
    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getDerivedFrom() {
        return this.derivedFrom;
    }

    @Override
    public void setDerivedFrom(String derivedFrom) {
        this.derivedFrom = derivedFrom;
    }

    public String getDerivedFromRoot() {
        return this.derivedFromRoot;
    }

    @Override
    public void setDerivedFromRoot(String derivedFromRoot) {
        this.derivedFromRoot = derivedFromRoot;
    }

    public String toString() {
        return "DeploymentEntity[id=" + this.id + ", name=" + this.name + "]";
    }
}

