/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class TaskOwnerChangedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    @Override
    public String getType() {
        return "task-owner-changed";
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String owner = this.getStringFromJson(historicalData, "owner");
        String taskId = this.getStringFromJson(historicalData, "id");
        HistoricIdentityLinkService historicIdentityLinkService = CommandContextUtil.getHistoricIdentityLinkService();
        HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
        historicIdentityLinkEntity.setTaskId(taskId);
        historicIdentityLinkEntity.setType("owner");
        historicIdentityLinkEntity.setUserId(owner);
        historicIdentityLinkEntity.setCreateTime(this.getDateFromJson(historicalData, "createTime"));
        historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
    }
}

