/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.bpmn.diagram.ProcessDiagramLayoutFactory;
import org.flowable.engine.impl.cmd.GetDeploymentProcessDiagramCmd;
import org.flowable.engine.impl.cmd.GetDeploymentProcessModelCmd;
import org.flowable.engine.repository.DiagramLayout;

public class GetDeploymentProcessDiagramLayoutCmd
implements Command<DiagramLayout>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetDeploymentProcessDiagramLayoutCmd(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.length() < 1) {
            throw new FlowableException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    public DiagramLayout execute(CommandContext commandContext) {
        InputStream processModelStream = new GetDeploymentProcessModelCmd(this.processDefinitionId).execute(commandContext);
        InputStream processDiagramStream = new GetDeploymentProcessDiagramCmd(this.processDefinitionId).execute(commandContext);
        return new ProcessDiagramLayoutFactory().getProcessDiagramLayout(processModelStream, processDiagramStream);
    }
}

