/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.configurator;

import java.util.ArrayList;
import java.util.List;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.deployer.DmnDeployer;
import org.flowable.dmn.engine.impl.cfg.StandaloneInMemDmnEngineConfiguration;
import org.flowable.dmn.engine.impl.db.EntityDependencyOrder;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.AbstractEngineConfigurator;
import org.flowable.engine.common.impl.EngineDeployer;
import org.flowable.engine.common.impl.persistence.entity.Entity;

public class DmnEngineConfigurator
extends AbstractEngineConfigurator {
    protected DmnEngineConfiguration dmnEngineConfiguration;

    public int getPriority() {
        return 200000;
    }

    protected List<EngineDeployer> getCustomDeployers() {
        ArrayList<EngineDeployer> deployers = new ArrayList<EngineDeployer>();
        deployers.add(new DmnDeployer());
        return deployers;
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/dmn/db/mapping/mappings.xml";
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.dmnEngineConfiguration == null) {
            this.dmnEngineConfiguration = new StandaloneInMemDmnEngineConfiguration();
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
        this.initDmnEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.dmnEngineConfiguration);
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    protected synchronized DmnEngine initDmnEngine() {
        if (this.dmnEngineConfiguration == null) {
            throw new FlowableException("DmnEngineConfiguration is required");
        }
        return this.dmnEngineConfiguration.buildDmnEngine();
    }

    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }

    public DmnEngineConfigurator setDmnEngineConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        return this;
    }
}

