/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring.autodeployment;

import java.io.IOException;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.repository.CmmnDeploymentBuilder;
import org.flowable.cmmn.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.flowable.engine.common.api.FlowableException;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "default";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, CmmnRepositoryService repositoryService) {
        CmmnDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            try {
                deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
            }
            catch (IOException e) {
                throw new FlowableException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
        }
        deploymentBuilder.deploy();
    }
}

