/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import com.google.common.annotations.VisibleForTesting;
import io.netty.handler.codec.http.HttpStatusClass;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.AsyncResultCallback;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.Const;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.registry.ServiceCenterInfo;
import org.apache.servicecomb.serviceregistry.api.request.CreateSchemaRequest;
import org.apache.servicecomb.serviceregistry.api.request.CreateServiceRequest;
import org.apache.servicecomb.serviceregistry.api.request.RegisterInstanceRequest;
import org.apache.servicecomb.serviceregistry.api.request.UpdatePropertiesRequest;
import org.apache.servicecomb.serviceregistry.api.response.CreateServiceResponse;
import org.apache.servicecomb.serviceregistry.api.response.FindInstancesResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetAllServicesResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetExistenceResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetInstancesResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetSchemaResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetSchemasResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetServiceResponse;
import org.apache.servicecomb.serviceregistry.api.response.HeartbeatResponse;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceResponse;
import org.apache.servicecomb.serviceregistry.api.response.RegisterInstanceResponse;
import org.apache.servicecomb.serviceregistry.client.ClientException;
import org.apache.servicecomb.serviceregistry.client.IpPortManager;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.Holder;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.client.http.RequestContext;
import org.apache.servicecomb.serviceregistry.client.http.RequestParam;
import org.apache.servicecomb.serviceregistry.client.http.RestResponse;
import org.apache.servicecomb.serviceregistry.client.http.RestUtils;
import org.apache.servicecomb.serviceregistry.client.http.WebsocketUtils;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceRegistryClientImpl
implements ServiceRegistryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryClientImpl.class);
    private IpPortManager ipPortManager;
    private Map<String, Boolean> watchServices = new ConcurrentHashMap<String, Boolean>();

    public ServiceRegistryClientImpl(IpPortManager ipPortManager) {
        this.ipPortManager = ipPortManager;
    }

    @Override
    public void init() {
    }

    private void retry(RequestContext requestContext, Handler<RestResponse> responseHandler) {
        LOGGER.warn("invoke service [{}] failed, retry.", (Object)requestContext.getUri());
        requestContext.setIpPort(this.ipPortManager.getNextAvailableAddress(requestContext.getIpPort()));
        requestContext.incrementRetryTimes();
        RestUtils.httpDo(requestContext, responseHandler);
    }

    @VisibleForTesting
    protected <T> Handler<RestResponse> syncHandler(CountDownLatch countDownLatch, Class<T> cls, Holder<T> holder) {
        return restResponse -> {
            RequestContext requestContext = restResponse.getRequestContext();
            HttpClientResponse response = restResponse.getResponse();
            if (response == null) {
                if (requestContext.getRetryTimes() <= this.ipPortManager.getMaxRetryTimes()) {
                    this.retry(requestContext, this.syncHandler(countDownLatch, cls, holder));
                } else {
                    countDownLatch.countDown();
                }
                return;
            }
            holder.setStatusCode(response.statusCode());
            response.bodyHandler(bodyBuffer -> {
                if (cls.getName().equals(HttpClientResponse.class.getName())) {
                    holder.value = response;
                    countDownLatch.countDown();
                    return;
                }
                if (cls.equals(String.class)) {
                    holder.setValue(bodyBuffer.toString());
                    countDownLatch.countDown();
                    return;
                }
                if (!HttpStatusClass.SUCCESS.equals((Object)HttpStatusClass.valueOf((int)response.statusCode()))) {
                    LOGGER.warn("get response for {} failed, {}:{}, {}", new Object[]{cls.getName(), response.statusCode(), response.statusMessage(), bodyBuffer.toString()});
                    countDownLatch.countDown();
                    return;
                }
                try {
                    holder.value = JsonUtils.readValue((byte[])bodyBuffer.getBytes(), (Class)cls);
                }
                catch (Exception e) {
                    holder.setStatusCode(0).setThrowable(e);
                    LOGGER.warn("read value failed and response message is {}", (Object)bodyBuffer.toString());
                }
                countDownLatch.countDown();
            });
        };
    }

    private Handler<RestResponse> syncHandlerEx(CountDownLatch countDownLatch, Holder<ResponseWrapper> holder) {
        return restResponse -> {
            RequestContext requestContext = restResponse.getRequestContext();
            HttpClientResponse response = restResponse.getResponse();
            if (response == null) {
                if (requestContext.getRetryTimes() <= this.ipPortManager.getMaxRetryTimes()) {
                    this.retry(requestContext, this.syncHandlerEx(countDownLatch, holder));
                } else {
                    countDownLatch.countDown();
                }
                return;
            }
            response.bodyHandler(bodyBuffer -> {
                ResponseWrapper responseWrapper = new ResponseWrapper();
                responseWrapper.response = response;
                responseWrapper.bodyBuffer = bodyBuffer;
                holder.value = responseWrapper;
                countDownLatch.countDown();
            });
        };
    }

    private Handler<RestResponse> syncHandlerForInstances(CountDownLatch countDownLatch, MicroserviceInstances mInstances) {
        return restResponse -> {
            RequestContext requestContext = restResponse.getRequestContext();
            HttpClientResponse response = restResponse.getResponse();
            if (response == null) {
                if (requestContext.getRetryTimes() <= this.ipPortManager.getMaxRetryTimes()) {
                    this.retry(requestContext, this.syncHandlerForInstances(countDownLatch, mInstances));
                } else {
                    countDownLatch.countDown();
                }
                return;
            }
            response.bodyHandler(bodyBuffer -> {
                try {
                    mInstances.setRevision(response.getHeader("X-Resource-Revision"));
                    switch (response.statusCode()) {
                        case 304: {
                            mInstances.setNeedRefresh(false);
                            break;
                        }
                        case 200: {
                            mInstances.setInstancesResponse((FindInstancesResponse)JsonUtils.readValue((byte[])bodyBuffer.getBytes(), FindInstancesResponse.class));
                            break;
                        }
                        case 400: {
                            Map error = (Map)JsonUtils.readValue((byte[])bodyBuffer.getBytes(), Map.class);
                            if ("400012".equals(error.get("errorCode"))) {
                                mInstances.setMicroserviceNotExist(true);
                                mInstances.setNeedRefresh(false);
                            }
                            LOGGER.warn("failed to findInstances: " + bodyBuffer.toString());
                            break;
                        }
                        default: {
                            LOGGER.warn("failed to findInstances: " + bodyBuffer.toString());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("read value failed and response message is {}", (Object)bodyBuffer.toString());
                }
                countDownLatch.countDown();
            });
        };
    }

    @Override
    public List<Microservice> getAllMicroservices() {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, Const.REGISTRY_API.MICROSERVICE_OPERATION_ALL, new RequestParam(), this.syncHandler(countDownLatch, GetAllServicesResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetAllServicesResponse)holder.value).getServices();
            }
        }
        catch (Exception e) {
            LOGGER.error("query all microservices failed", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public String getMicroserviceId(String appId, String microserviceName, String versionRule, String environment) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, Const.REGISTRY_API.MICROSERVICE_EXISTENCE, new RequestParam().addQueryParam("type", "microservice").addQueryParam("appId", appId).addQueryParam("serviceName", microserviceName).addQueryParam("version", versionRule).addQueryParam("env", environment), this.syncHandler(countDownLatch, GetExistenceResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetExistenceResponse)holder.value).getServiceId();
            }
        }
        catch (Exception e) {
            LOGGER.error("query microservice id {}/{}/{} fail", new Object[]{appId, microserviceName, versionRule, e});
        }
        return null;
    }

    @Override
    public boolean isSchemaExist(String microserviceId, String schemaId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, Const.REGISTRY_API.MICROSERVICE_EXISTENCE, new RequestParam().addQueryParam("type", "schema").addQueryParam("serviceId", microserviceId).addQueryParam("schemaId", schemaId), this.syncHandler(countDownLatch, GetExistenceResponse.class, holder));
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            LOGGER.error("query schema exist {}/{} fail", new Object[]{microserviceId, schemaId, e});
        }
        return holder.value != null && schemaId.equals(((GetExistenceResponse)holder.value).getSchemaId());
    }

    @Override
    public boolean registerSchema(String microserviceId, String schemaId, String schemaContent) {
        Holder<ResponseWrapper> holder = new Holder<ResponseWrapper>();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            CreateSchemaRequest request = new CreateSchemaRequest();
            request.setSchema(schemaContent);
            request.setSummary(RegistryUtils.calcSchemaSummary(schemaContent));
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            RestUtils.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_SCHEMA, microserviceId, schemaId), new RequestParam().setBody(body), this.syncHandlerEx(countDownLatch, holder));
            countDownLatch.await();
            if (holder.value == null) {
                LOGGER.error("Register schema {}/{} failed.", (Object)microserviceId, (Object)schemaId);
                return false;
            }
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)((ResponseWrapper)holder.value).response.statusCode()))) {
                LOGGER.error("Register schema {}/{} failed, statusCode: {}, statusMessage: {}, description: {}.", new Object[]{microserviceId, schemaId, ((ResponseWrapper)holder.value).response.statusCode(), ((ResponseWrapper)holder.value).response.statusMessage(), ((ResponseWrapper)holder.value).bodyBuffer.toString()});
                return false;
            }
            LOGGER.info("register schema {}/{} success.", (Object)microserviceId, (Object)schemaId);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("register schema {}/{} fail.", new Object[]{microserviceId, schemaId, e});
            return false;
        }
    }

    @Override
    public String getSchema(String microserviceId, String schemaId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_SCHEMA, microserviceId, schemaId), new RequestParam(), this.syncHandler(countDownLatch, GetSchemaResponse.class, holder));
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            LOGGER.error("query schema exist {}/{} failed", new Object[]{microserviceId, schemaId, e});
        }
        if (holder.value != null) {
            return ((GetSchemaResponse)holder.value).getSchema();
        }
        return null;
    }

    @Override
    public Holder<List<GetSchemaResponse>> getSchemas(String microserviceId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        Holder<List<GetSchemaResponse>> resultHolder = new Holder<List<GetSchemaResponse>>();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_ALL_SCHEMAs, microserviceId), new RequestParam(), this.syncHandler(countDownLatch, GetSchemasResponse.class, holder));
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            LOGGER.error("query all schemas {} failed", (Object)microserviceId, (Object)e);
        }
        resultHolder.setStatusCode(holder.getStatusCode()).setThrowable(holder.getThrowable());
        if (holder.value != null) {
            return resultHolder.setValue(((GetSchemasResponse)holder.value).getSchema() != null ? ((GetSchemasResponse)holder.value).getSchema() : ((GetSchemasResponse)holder.value).getSchemas());
        }
        return resultHolder;
    }

    @Override
    public String registerMicroservice(Microservice microservice) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            CreateServiceRequest request = new CreateServiceRequest();
            request.setService(microservice);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("register microservice: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            RestUtils.post(ipPort, Const.REGISTRY_API.MICROSERVICE_OPERATION_ALL, new RequestParam().setBody(body), this.syncHandler(countDownLatch, CreateServiceResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                return ((CreateServiceResponse)holder.value).getServiceId();
            }
        }
        catch (Exception e) {
            LOGGER.error("register microservice {}/{}/{} failed", new Object[]{microservice.getAppId(), microservice.getServiceName(), microservice.getVersion(), e});
        }
        return null;
    }

    @Override
    public Microservice getMicroservice(String microserviceId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_OPERATION_ONE, microserviceId), new RequestParam(), this.syncHandler(countDownLatch, GetServiceResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetServiceResponse)holder.value).getService();
            }
        }
        catch (Exception e) {
            LOGGER.error("query microservice {} failed", (Object)microserviceId, (Object)e);
        }
        return null;
    }

    @Override
    public String registerMicroserviceInstance(MicroserviceInstance instance) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            RegisterInstanceRequest request = new RegisterInstanceRequest();
            request.setInstance(instance);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("register microservice: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            RestUtils.post(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ALL, instance.getServiceId()), new RequestParam().setBody(body), this.syncHandler(countDownLatch, RegisterInstanceResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                return ((RegisterInstanceResponse)holder.value).getInstanceId();
            }
        }
        catch (Exception e) {
            LOGGER.error("register microservice instance {} failed", (Object)instance.getServiceId(), (Object)e);
        }
        return null;
    }

    @Override
    public List<MicroserviceInstance> getMicroserviceInstance(String consumerId, String providerId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ALL, providerId), new RequestParam().addHeader("X-ConsumerId", consumerId), this.syncHandler(countDownLatch, GetInstancesResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetInstancesResponse)holder.value).getInstances();
            }
        }
        catch (Exception e) {
            LOGGER.error("query microservice instances {} failed", (Object)providerId, (Object)e);
        }
        return null;
    }

    @Override
    public boolean unregisterMicroserviceInstance(String microserviceId, String microserviceInstanceId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.delete(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ONE, microserviceId, microserviceInstanceId), new RequestParam(), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    return true;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("unregister microservice instance {}/{} failed", new Object[]{microserviceId, microserviceInstanceId, e});
        }
        return false;
    }

    @Override
    public HeartbeatResponse heartbeat(String microserviceId, String microserviceInstanceId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_HEARTBEAT, microserviceId, microserviceInstanceId), new RequestParam().setTimeout(ServiceRegistryConfig.INSTANCE.getHeartBeatRequestTimeout()), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                HeartbeatResponse response = new HeartbeatResponse();
                response.setMessage(((HttpClientResponse)holder.value).statusMessage());
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    response.setOk(true);
                    return response;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
                return response;
            }
        }
        catch (Exception e) {
            LOGGER.error("update microservice instance {}/{} heartbeat failed", new Object[]{microserviceId, microserviceInstanceId, e});
        }
        return null;
    }

    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback) {
        this.watch(selfMicroserviceId, callback, (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}), (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback, AsyncResultCallback<Void> onOpen, AsyncResultCallback<Void> onClose) {
        Boolean alreadyWatch = this.watchServices.get(selfMicroserviceId);
        if (alreadyWatch != null) return;
        Class<ServiceRegistryClientImpl> clazz = ServiceRegistryClientImpl.class;
        synchronized (ServiceRegistryClientImpl.class) {
            alreadyWatch = this.watchServices.get(selfMicroserviceId);
            if (alreadyWatch != null) return;
            this.watchServices.put(selfMicroserviceId, true);
            String url = String.format(Const.REGISTRY_API.MICROSERVICE_WATCH, selfMicroserviceId);
            IpPort ipPort = this.ipPortManager.getAvailableAddress();
            WebsocketUtils.open(ipPort, url, (Handler<Void>)((Handler)o -> {
                onOpen.success(o);
                LOGGER.info("watching microservice {} successfully, the chosen service center address is {}:{}", new Object[]{selfMicroserviceId, ipPort.getHostOrIp(), ipPort.getPort()});
            }), (Handler<Void>)((Handler)c -> {
                this.watchErrorHandler(new ClientException("connection is closed accidentally"), selfMicroserviceId, callback);
                onClose.success(null);
            }), (Handler<Buffer>)((Handler)bodyBuffer -> {
                MicroserviceInstanceChangedEvent response = null;
                try {
                    response = (MicroserviceInstanceChangedEvent)JsonUtils.readValue((byte[])bodyBuffer.getBytes(), MicroserviceInstanceChangedEvent.class);
                }
                catch (Exception e) {
                    LOGGER.error("watcher handle microservice {} response failed, {}", (Object)selfMicroserviceId, (Object)bodyBuffer.toString());
                    return;
                }
                try {
                    callback.success((Object)response);
                }
                catch (Exception e) {
                    LOGGER.error("notify watcher failed, microservice {}", (Object)selfMicroserviceId, (Object)e);
                }
            }), (Handler<Throwable>)((Handler)e -> {
                this.watchErrorHandler((Throwable)e, selfMicroserviceId, callback);
                onClose.success(null);
            }), (Handler<Throwable>)((Handler)f -> this.watchErrorHandler((Throwable)f, selfMicroserviceId, callback)));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<MicroserviceInstance> findServiceInstance(String consumerId, String appId, String serviceName, String versionRule) {
        MicroserviceInstances instances = this.findServiceInstances(consumerId, appId, serviceName, versionRule, null);
        if (instances == null) {
            return null;
        }
        return instances.getInstancesResponse().getInstances();
    }

    @Override
    public MicroserviceInstances findServiceInstances(String consumerId, String appId, String serviceName, String versionRule, String revision) {
        if (consumerId == null) {
            LOGGER.error("find microservice instance {}/{}/{} failed, not registered to serviceCenter.", new Object[]{appId, serviceName, versionRule});
            return null;
        }
        MicroserviceInstances microserviceInstances = new MicroserviceInstances();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RequestParam requestParam = new RequestParam().addQueryParam("appId", appId).addQueryParam("serviceName", serviceName).addQueryParam("version", versionRule).addHeader("X-ConsumerId", consumerId);
        if (revision != null) {
            requestParam.addQueryParam("rev", revision);
        }
        RestUtils.get(ipPort, Const.REGISTRY_API.MICROSERVICE_INSTANCES, requestParam, this.syncHandlerForInstances(countDownLatch, microserviceInstances));
        try {
            countDownLatch.await();
            if (!microserviceInstances.isNeedRefresh()) {
                return microserviceInstances;
            }
            if (microserviceInstances.getInstancesResponse() == null) {
                return null;
            }
            List<MicroserviceInstance> list = microserviceInstances.getInstancesResponse().getInstances();
            if (list == null) {
                microserviceInstances.getInstancesResponse().setInstances(new ArrayList<MicroserviceInstance>());
            }
            return microserviceInstances;
        }
        catch (Exception e) {
            LOGGER.error("find microservice instance {}/{}/{} failed", new Object[]{appId, serviceName, versionRule, e});
            return null;
        }
    }

    private void watchErrorHandler(Throwable e, String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback) {
        LOGGER.error("watcher connect to service center server failed, microservice {}, {}", (Object)selfMicroserviceId, (Object)e.getMessage());
        callback.fail(e);
        this.watchServices.remove(selfMicroserviceId);
    }

    @Override
    public boolean updateMicroserviceProperties(String microserviceId, Map<String, String> serviceProperties) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            UpdatePropertiesRequest request = new UpdatePropertiesRequest();
            request.setProperties(serviceProperties);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("update properties of microservice: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            RestUtils.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_PROPERTIES, microserviceId), new RequestParam().setBody(body), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    return true;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("update properties of microservice {} failed", (Object)microserviceId, (Object)e);
        }
        return false;
    }

    @Override
    public boolean updateInstanceProperties(String microserviceId, String microserviceInstanceId, Map<String, String> instanceProperties) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            UpdatePropertiesRequest request = new UpdatePropertiesRequest();
            request.setProperties(instanceProperties);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("update properties of microservice instance: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            RestUtils.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_PROPERTIES, microserviceId, microserviceInstanceId), new RequestParam().setBody(body), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    return true;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("update properties of microservice instance {}/{} failed", new Object[]{microserviceId, microserviceInstanceId, e});
        }
        return false;
    }

    @Override
    public MicroserviceInstance findServiceInstance(String serviceId, String instanceId) {
        try {
            Holder holder = new Holder();
            IpPort ipPort = this.ipPortManager.getAvailableAddress();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            RestUtils.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ONE, serviceId, instanceId), new RequestParam().addHeader("X-ConsumerId", serviceId), this.syncHandler(countDownLatch, MicroserviceInstanceResponse.class, holder));
            countDownLatch.await();
            if (null != holder.value) {
                return ((MicroserviceInstanceResponse)holder.value).getInstance();
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("get instance from sc failed");
            return null;
        }
    }

    @Override
    public ServiceCenterInfo getServiceCenterInfo() {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RestUtils.get(ipPort, Const.REGISTRY_API.SERVICECENTER_VERSION, new RequestParam(), this.syncHandler(countDownLatch, ServiceCenterInfo.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return (ServiceCenterInfo)holder.value;
            }
        }
        catch (Exception e) {
            LOGGER.error("query servicecenter version info failed.", (Throwable)e);
        }
        return null;
    }

    static class ResponseWrapper {
        HttpClientResponse response;
        Buffer bodyBuffer;

        ResponseWrapper() {
        }
    }
}

