/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class SPIServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPIServiceUtils.class);

    private SPIServiceUtils() {
    }

    public static <T> T getTargetService(Class<T> serviceType) {
        ServiceLoader<T> loader = ServiceLoader.load(serviceType);
        Iterator<T> iterator = loader.iterator();
        if (iterator.hasNext()) {
            T service = iterator.next();
            LOGGER.info("get the SPI service success, the extend service is: {}", service.getClass());
            return service;
        }
        LOGGER.info("Can not get the SPI service, the interface type is: {}", (Object)serviceType.toString());
        return null;
    }

    public static <T> List<T> getAllService(Class<T> serviceType) {
        ArrayList list = new ArrayList();
        ServiceLoader.load(serviceType).forEach(list::add);
        return list;
    }

    public static <T> List<T> getSortedService(Class<T> serviceType) {
        ArrayList serviceEntries = new ArrayList();
        ServiceLoader<Object> serviceLoader = ServiceLoader.load(serviceType);
        serviceLoader.forEach(service -> {
            int serviceOrder = 0;
            Method getOrder = ReflectionUtils.findMethod(service.getClass(), (String)"getOrder");
            if (getOrder != null) {
                serviceOrder = (Integer)ReflectionUtils.invokeMethod((Method)getOrder, (Object)service);
            }
            AbstractMap.SimpleEntry<Integer, Object> entry = new AbstractMap.SimpleEntry<Integer, Object>(serviceOrder, service);
            serviceEntries.add(entry);
        });
        return serviceEntries.stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public static <T> T getPriorityHighestService(Class<T> serviceType) {
        List<T> services = SPIServiceUtils.getSortedService(serviceType);
        if (services.isEmpty()) {
            return null;
        }
        return services.get(0);
    }
}

