/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.config.impl;

import java.util.List;
import org.apache.servicecomb.foundation.common.config.PaaSResourceUtils;
import org.apache.servicecomb.foundation.common.config.impl.AbstractLoader;
import org.apache.servicecomb.foundation.common.config.impl.XmlLoaderUtils;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlLoader
extends AbstractLoader {
    private String suffix;

    public XmlLoader(List<String> locationPatternList) {
        this(locationPatternList, ".xml");
    }

    public XmlLoader(List<String> locationPatternList, String suffix) {
        super(locationPatternList);
        this.suffix = suffix;
    }

    @Override
    public <T> T load() throws Exception {
        Document doc = XmlLoaderUtils.newDoc();
        Element root = null;
        for (String locationPattern : this.locationPatternList) {
            List<Resource> resList = PaaSResourceUtils.getSortedResources(locationPattern, this.suffix);
            for (Resource res : resList) {
                Document tmpDoc = XmlLoaderUtils.load(res);
                Element tmpRoot = tmpDoc.getDocumentElement();
                if (root == null) {
                    root = (Element)doc.importNode(tmpRoot, false);
                    doc.appendChild(root);
                }
                NodeList nodeList = tmpRoot.getChildNodes();
                for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                    Node child = nodeList.item(idx);
                    if (!Element.class.isInstance(child)) continue;
                    Element clone = (Element)doc.importNode(child, true);
                    Element exist = this.findAndSetExist(clone);
                    if (exist == null) {
                        root.appendChild(clone);
                        continue;
                    }
                    XmlLoaderUtils.mergeElement(clone, exist);
                }
            }
        }
        return (T)doc;
    }

    protected Element findAndSetExist(Element ele) {
        return null;
    }
}

