/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.foundation.common.config.ConfigLoader;
import org.apache.servicecomb.foundation.common.config.PaaSResourceUtils;
import org.apache.servicecomb.foundation.common.config.impl.AbstractLoader;
import org.apache.servicecomb.foundation.common.config.impl.IncConfigs;
import org.apache.servicecomb.foundation.common.config.impl.PropertiesLoader;
import org.apache.servicecomb.foundation.common.config.impl.XmlLoader;
import org.apache.servicecomb.foundation.common.config.impl.XmlLoaderUtils;
import org.springframework.core.io.Resource;

public class ConfigMgr {
    public static final ConfigMgr INSTANCE = new ConfigMgr();
    private Map<String, Object> configMap = new ConcurrentHashMap<String, Object>();
    private Map<String, ConfigLoader> configLoaderMap;

    public void init() throws Exception {
        AbstractLoader loader;
        List<Resource> resArr = PaaSResourceUtils.getSortedResources("classpath*:config/config.inc.xml", ".inc.xml");
        IncConfigs incConfigs = new IncConfigs();
        incConfigs.setPropertiesList(new ArrayList<IncConfigs.IncConfig>());
        incConfigs.setXmlList(new ArrayList<IncConfigs.IncConfig>());
        for (Resource resource : resArr) {
            IncConfigs tmp = (IncConfigs)XmlLoaderUtils.load(resource, IncConfigs.class);
            if (tmp.getPropertiesList() != null) {
                incConfigs.getPropertiesList().addAll(tmp.getPropertiesList());
            }
            if (tmp.getXmlList() == null) continue;
            incConfigs.getXmlList().addAll(tmp.getXmlList());
        }
        this.configLoaderMap = new HashMap<String, ConfigLoader>();
        for (IncConfigs.IncConfig incConfig : incConfigs.getPropertiesList()) {
            loader = (PropertiesLoader)this.configLoaderMap.get(incConfig.getId());
            if (loader != null) {
                loader.getLocationPatternList().addAll(incConfig.getPathList());
                continue;
            }
            this.configLoaderMap.put(incConfig.getId(), new PropertiesLoader(incConfig.getPathList()));
        }
        for (IncConfigs.IncConfig incConfig : incConfigs.getXmlList()) {
            loader = (XmlLoader)this.configLoaderMap.get(incConfig.getId());
            if (loader != null) {
                loader.getLocationPatternList().addAll(incConfig.getPathList());
                continue;
            }
            this.configLoaderMap.put(incConfig.getId(), new XmlLoader(incConfig.getPathList()));
        }
    }

    public <T> T getConfig(String configId) throws Exception {
        ConfigLoader loader;
        Object config = this.configMap.get(configId);
        if (config != null) {
            return (T)config;
        }
        if (this.configLoaderMap == null) {
            this.init();
        }
        if ((loader = this.configLoaderMap.get(configId)) == null) {
            throw new RuntimeException("can not find config for " + configId);
        }
        config = loader.load();
        this.configMap.put(configId, config);
        return (T)config;
    }
}

