/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.SmartStackTraceParser;
import org.apache.maven.surefire.report.StackTraceWriter;

public class PojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    protected final String testClass;
    protected final String testMethod;

    public PojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    public String writeTraceToString() {
        StringWriter w = new StringWriter();
        if (this.t != null) {
            this.t.printStackTrace(new PrintWriter(w));
            w.flush();
        }
        return w.toString();
    }

    public String smartTrimmedStackTrace() {
        SmartStackTraceParser parser = new SmartStackTraceParser(this.testClass, this.t, this.testMethod);
        return parser.getString();
    }

    public String writeTrimmedTraceToString() {
        return SmartStackTraceParser.innerMostWithFocusOnClass(this.t, this.testClass);
    }

    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.t);
    }
}

