/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="attach-descriptor", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class SiteDescriptorAttachMojo
extends AbstractSiteMojo {
    @Parameter(property="basedir", required=true, readonly=true)
    private File basedir;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="true")
    private boolean pomPackagingOnly;

    public void execute() throws MojoExecutionException {
        if (this.pomPackagingOnly && !"pom".equals(this.project.getPackaging())) {
            return;
        }
        List localesList = this.siteTool.getAvailableLocales(this.locales);
        for (Locale locale : localesList) {
            File descriptorFile = this.siteTool.getSiteDescriptorFromBasedir(this.siteTool.getRelativePath(this.siteDirectory.getAbsolutePath(), this.project.getBasedir().getAbsolutePath()), this.basedir, locale);
            if (!descriptorFile.exists()) continue;
            String classifier = SiteDescriptorAttachMojo.getClassifier(descriptorFile);
            String filename = this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + descriptorFile.getName();
            File targetDescriptorFile = new File(this.project.getBuild().getDirectory(), filename);
            try {
                FileUtils.copyFile((File)descriptorFile, (File)targetDescriptorFile);
                this.getLog().debug((CharSequence)("Attaching the site descriptor '" + targetDescriptorFile.getAbsolutePath() + "' with classifier '" + classifier + "' to the project."));
                this.projectHelper.attachArtifact(this.project, "xml", classifier, targetDescriptorFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy site descriptor", (Exception)e);
            }
        }
    }

    private static String getClassifier(File descriptorFile) throws MojoExecutionException {
        int index = descriptorFile.getName().lastIndexOf(46);
        if (index > 0) {
            return descriptorFile.getName().substring(0, index);
        }
        throw new MojoExecutionException("Unable to determine the classifier to use");
    }
}

